package ru.yandex.chemodan.app.lentaloader.web;

import org.joda.time.Instant;
import org.joda.time.format.ISODateTimeFormat;

import ru.yandex.chemodan.util.bender.UnderscoreNamesBenderConfiguration;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactory;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.ReadableInstantConfigurableMarshaller;

/**
 * @author dbrylev
 */
public class WebBender {

    public static final BenderMapper mapper = new BenderMapper(getConfiguration());

    private static BenderConfiguration getConfiguration() {
        return UnderscoreNamesBenderConfiguration.extend(BenderConfiguration.cons(
                MembersToBind.WITH_ANNOTATIONS, false, customBinders()));
    }

    private static CustomMarshallerUnmarshallerFactory customBinders() {
        return CustomMarshallerUnmarshallerFactoryBuilder
                .cons()
                .add(Instant.class, new ReadableInstantConfigurableMarshaller(ISODateTimeFormat.dateTime()))
                .build();
    }
}
