package ru.yandex.chemodan.app.lentaloader.web;

import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.dataapi.web.convert.ConvertToDataapiUser;
import ru.yandex.chemodan.app.lentaloader.LentaBlocksContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.LentaCoreContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.LentaEventsLogListener;
import ru.yandex.chemodan.app.lentaloader.blocks.FolderCreationBlockManager;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaManager;
import ru.yandex.chemodan.boot.ChemodanActionAppConfigurator;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.chemodan.util.web.interceptors.ThreadLocalCacheInterceptor;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.Feature;
import ru.yandex.commune.a3.action.result.AddCommonAttributesInterceptor;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.bazinga.BazingaTaskManager;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        LentaBlocksContextConfiguration.class,
        LentaCoreContextConfiguration.class,
        A3JettyContextConfiguration.class
})
public class WebContextConfiguration {

    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(Tuple2List.fromPairs(
                "/api/*", ""
        ));
    }

    @Bean
    public LentaActions lentaActions(LentaManager lentaManager,
            FolderCreationBlockManager folderCreationBlockManager,
            LentaEventsLogListener lentaEventsLogListener,
            BazingaTaskManager bazingaTaskManager)
    {
        return new LentaActions(lentaManager, folderCreationBlockManager, lentaEventsLogListener,
                bazingaTaskManager);
    }

    @Bean
    public ActionApp actionApp(ApplicationContext context, ApplicationInfo applicationInfo) {

        ChemodanActionAppConfigurator configurator = ChemodanActionAppConfigurator.cons(applicationInfo, context);
        configurator.getBuilder().disable(Feature.USE_SECURITY);
        configurator
                .addJsonBendingWithoutInvocationInfo(WebBender.mapper).getBuilder()

                .addConverters(Cf.list(
                        new ConvertToDataapiUser(),
                        new ConverterToMpfsResourceId()))

                .addInvocationInterceptors(Cf.list(
                        new AddCommonAttributesInterceptor(applicationInfo),
                        new ThreadLocalCacheInterceptor()))
        ;

        ActionApp app = configurator.configure();

        return app;
    }
}
