package ru.yandex.chemodan.app.lentaloader.worker;

import ru.yandex.chemodan.app.lentaloader.log.ActionInfo;
import ru.yandex.chemodan.app.lentaloader.log.ActionSource;
import ru.yandex.chemodan.app.lentaloader.log.ActionSourceHolder;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTask;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTaskParameters;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;

/**
 * @author dbrylev
 */
public abstract class LentaCeleryTaskSupport extends CeleryOnetimeTask {

    public LentaCeleryTaskSupport(CeleryOnetimeTaskParameters parameters) {
        super(parameters);
    }

    public LentaCeleryTaskSupport() {
        super();
    }

    protected abstract void doExecute(CeleryOnetimeTaskParameters parameters, ExecutionContext context) throws Exception;

    @Override
    protected void execute(CeleryOnetimeTaskParameters parameters, ExecutionContext context) throws Exception {
        ActionSourceHolder.invokeWith(ActionSource.celeryTask(context.getFullJobId()), () -> doExecute(parameters, context));
    }

    protected ActionInfo getActionInfo() {
        return ActionInfo.internal(ActionSourceHolder.getOrThrow());
    }
}
