package ru.yandex.chemodan.app.lentaloader.worker;

import ru.yandex.chemodan.app.lentaloader.log.ActionInfo;
import ru.yandex.chemodan.app.lentaloader.log.ActionSource;
import ru.yandex.chemodan.app.lentaloader.log.ActionSourceHolder;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;

/**
 * @author dbrylev
 */
public abstract class LentaCronTaskSupport extends CronTask {

    protected abstract void doExecute(ExecutionContext context) throws Exception;

    @Override
    public final void execute(ExecutionContext context) throws Exception {
        ActionSourceHolder.invokeWith(ActionSource.bazingaTask(context.getFullJobId()), () -> doExecute(context));
    }

    protected ActionInfo getActionInfo() {
        return ActionInfo.internal(ActionSourceHolder.getOrThrow());
    }

    @Override
    public TaskQueueName queueName() {
        return LentaTaskQueueName.LENTA_CRON;
    }
}
