package ru.yandex.chemodan.app.lentaloader.worker;

import ru.yandex.chemodan.app.lentaloader.log.ActionInfo;
import ru.yandex.chemodan.app.lentaloader.log.ActionSource;
import ru.yandex.chemodan.app.lentaloader.log.ActionSourceHolder;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;

/**
 * @author dbrylev
 */
public abstract class LentaOnetimeTaskSupport<T> extends OnetimeTaskSupport<T> {

    public LentaOnetimeTaskSupport(T parameters) {
        super(parameters);
    }

    public LentaOnetimeTaskSupport(Class<T> parametersClass) {
        super(parametersClass);
    }

    protected abstract void doExecute(T parameters, ExecutionContext context) throws Exception;

    @Override
    protected final void execute(T parameters, ExecutionContext context) throws Exception {
        ActionSourceHolder.invokeWith(
                ActionSource.bazingaTask(context.getFullJobId()),
                () -> doExecute(parameters, context));
    }

    protected ActionInfo getActionInfo() {
        return ActionInfo.internal(ActionSourceHolder.getOrThrow());
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public TaskQueueName queueName() {
        return LentaTaskQueueName.LENTA_REGULAR;
    }
}
