package ru.yandex.chemodan.app.lentaloader.worker;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.memories.CollectUidsWithBlocksTask;
import ru.yandex.chemodan.bazinga.BazingaWorkerTaskQueues;
import ru.yandex.chemodan.bazinga.ChemodanBazingaWorkerContextConfiguration;
import ru.yandex.chemodan.queller.worker.CeleryJavaWorkerContextConfiguration;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTask;
import ru.yandex.commune.bazinga.pg.worker.PgBazingaWorkerConfiguration;
import ru.yandex.commune.bazinga.scheduler.TaskQueue;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        ChemodanBazingaWorkerContextConfiguration.class,
        CeleryJavaWorkerContextConfiguration.class,
})
public class LentaWorkerContextConfiguration {

    @Bean
    public PgBazingaWorkerConfiguration pgBazingaWorkerConfiguration() {
        return new PgBazingaWorkerConfiguration(
                Cf.list(LentaTaskQueueName.LENTA_CRON, CeleryOnetimeTask.BAZINGA_QUEUE_NAME));
    }

    @Bean
    public BazingaWorkerTaskQueues taskQueues(
            @Value("${lenta-worker.set-memories-blocks.tasks.count}")
            int setMemoriesBlocksCount,
            @Value("${lenta-worker.set-memories-blocks.tasks.queue}")
            int setMemoriesBlocksQueue,
            @Value("${lenta-worker.cool.tasks.count}")
            int coolThreadCount,
            @Value("${lenta-worker.cool.tasks.queue}")
            int coolQueue,
            @Value("${lenta-worker.cool.schedule.tasks.count}")
            int coolScheduleThreadCount,
            @Value("${lenta-worker.cool.schedule.tasks.queue}")
            int coolScheduleQueue,
            @Value("${lenta-worker.cool.rotation.tasks.count}")
            int coolRotationThreadCount,
            @Value("${lenta-worker.cool.rotation.tasks.queue}")
            int coolRotationQueue)
    {
        return new BazingaWorkerTaskQueues(
                Option.of(LentaTaskQueueName.LENTA_CRON),
                Option.of(LentaTaskQueueName.LENTA_REGULAR),
                Option.empty(),
                Cf.list(
                        new TaskQueue(CeleryOnetimeTask.BAZINGA_QUEUE_NAME, 1, 0),
                        new TaskQueue(LentaTaskQueueName.LENTA_OFFLINE, 50, 100),
                        new TaskQueue(LentaTaskQueueName.LENTA_COOL, coolThreadCount, coolQueue),
                        new TaskQueue(LentaTaskQueueName.LENTA_COOL_SCHEDULE, coolScheduleThreadCount, coolScheduleQueue),
                        new TaskQueue(LentaTaskQueueName.LENTA_COOL_ROTATION, coolRotationThreadCount, coolRotationQueue),
                        new TaskQueue(CollectUidsWithBlocksTask.SET_MEMORIES_BLOCKS_QUEUE,
                                setMemoriesBlocksCount, setMemoriesBlocksQueue)
                ));
    }

}
