package ru.yandex.chemodan.app.lentaloader.worker.tasks;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.log.ActionEventData;
import ru.yandex.chemodan.app.lentaloader.log.ActionInfo;
import ru.yandex.chemodan.app.lentaloader.log.ActionReason;
import ru.yandex.chemodan.app.lentaloader.log.ReasonedAction;
import ru.yandex.chemodan.eventlog.events.EventType;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class ActionInfoParameters {
    public final Option<String> ycrid;
    public final Option<EventType> event;
    public final Option<Instant> time;
    public final Option<MapF<String, String>> data;
    public final Option<ActionReason> reason;

    public ActionInfoParameters(Option<String> ycrid, ReasonedAction actionInfo) {
        this(ycrid, actionInfo.actionInfo.event, Option.of(actionInfo.reason));
    }

    public ActionInfoParameters(
            Option<String> ycrid, Option<ActionEventData> event, Option<ActionReason> reason)
    {
        this.ycrid = ycrid;
        this.event = event.map(e -> e.type);
        this.time = event.map(e -> e.time);
        this.data = event.map(e -> e.data).filterMap(l -> Option.when(l.isNotEmpty(), l::toMap));
        this.reason = reason;
    }

    public ActionInfo getActionInfo(ActionInfo current) {
        return ActionInfo.asyncEvent(getLogEvent(), current.now, current.source);
    }

    public Option<ActionEventData> getLogEvent() {
        return event.map(type -> new ActionEventData(type, time.get(), data.getOrElse(Cf.map()).entries()));
    }
}
