package ru.yandex.chemodan.app.lentaloader.worker.tasks;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.lentaloader.blocks.ContentBlockManager;
import ru.yandex.chemodan.app.lentaloader.blocks.FolderCreationBlockAction;
import ru.yandex.chemodan.app.lentaloader.blocks.FolderCreationBlockFields;
import ru.yandex.chemodan.app.lentaloader.blocks.ResourceBlockManager;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaManager;
import ru.yandex.chemodan.app.lentaloader.lenta.update.DeleteHandler;
import ru.yandex.chemodan.app.lentaloader.log.ActionReason;
import ru.yandex.chemodan.app.lentaloader.log.DataOrRefusal;
import ru.yandex.chemodan.app.lentaloader.log.ReasonedAction;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author dbrylev
 */
public class DeleteEmptyLentaBlockTask extends ModifyBlockTaskSupport {

    private final static Logger logger = LoggerFactory.getLogger(DeleteEmptyLentaBlockTask.class);

    private ContentBlockManager contentBlockManager;
    private ResourceBlockManager resourceBlockManager;

    public DeleteEmptyLentaBlockTask(DataApiUserId uid, String blockId, ReasonedAction action) {
        super(uid, blockId, Option.of(action.reason), Option.of(action.actionInfo));
    }

    public DeleteEmptyLentaBlockTask(
            LentaManager lentaManager,
            ContentBlockManager contentBlockManager,
            ResourceBlockManager resourceBlockManager)
    {
        super(lentaManager);
        this.contentBlockManager = contentBlockManager;
        this.resourceBlockManager = resourceBlockManager;
    }

    @Override
    protected void execute(
            DataApiUserId uid, String blockId, Option<ActionReason> reason, ExecutionContext context) throws Exception
    {
        lentaManager.deleteBlock(uid, blockId, record -> {
            switch (record.type) {
                case CONTENT_BLOCK:
                    DataOrRefusal<Integer> count = contentBlockManager.getFilesCount(uid, record);

                    return count.isRefusal()
                            ? DeleteHandler.delete(reason.getOrElse(count.getRefusalReason()))
                            : DeleteHandler.ignore();
                case FOLDER_CREATION:
                    if (FolderCreationBlockFields.ACTION.getO(record).isSome(FolderCreationBlockAction.SAVING_PUBLIC)) {
                        return DeleteHandler.ignore();
                    }
                    break;
                case PUBLIC_RESOURCE_OWNED:
                    if (resourceBlockManager.getPublicHash(uid, record).isPresent()) {
                        logger.info("Delete of {} {} skip, public link exists", record, uid);
                        return DeleteHandler.ignore();
                    }
            }
            // TODO: ensure not empty to avoid race condition
            return DeleteHandler.delete(reason.getOrElse(ActionReason.UNSPECIFIED));

        }, getActionInfo());
    }

}
