package ru.yandex.chemodan.app.lentaloader.worker.tasks;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.bolts.collection.SetF;
import ru.yandex.commune.bazinga.BazingaBender;
import ru.yandex.misc.bender.parse.BenderParser;

/**
 * @author messiahlap
 */
public class FindAndDeleteOrUpdateLentaBlocksTaskTest {

    private static final BenderParser<FindAndDeleteOrUpdateLentaBlocksTask.Parameters> parser =
            BazingaBender.mapper.createParser(FindAndDeleteOrUpdateLentaBlocksTask.Parameters.class);

    @Test
    public void testParametersParsing() {
        String parametersJson = "{\"uid\": \"922352802\", " +
                "\"data\": {\"tgt_path\": \"/disk/Сервер/Мебель/ТЗ/ЗАКАЗ 544/544.docx\"}, " +
                "\"time\": 1574246368000, \"event\": \"fs-store-update\", " +
                "\"ycrid\": \"win-241cc1240c4e7ac2d1086085d2003fa7-myt4-d4c9088efe2c\", " +
                "\"filter\": {\"op\": \"starts-with\", \"field\": \"group_key\", " +
                "\"value\": \"1130000034343350:b4b7209d07934bd394d98e31b331d5e79b06fa19b4de4fbdbd3c9c41a3b8699e:document:\"}, " +
                "\"reason\": \"file-changed-or-removed\", \"blockType\": \"content-block\"}";
        Assert.assertNotNull(parser.parseJson(parametersJson));
        parametersJson = "{\"uid\": \"922352802\", " +
                "\"data\": {\"tgt_path\": \"/disk/Сервер/Мебель/ТЗ/ЗАКАЗ 544/544.docx\"}, " +
                "\"time\": 1574246368000, \"event\": \"fs-store-update\", " +
                "\"ycrid\": \"win-241cc1240c4e7ac2d1086085d2003fa7-myt4-d4c9088efe2c\", " +
                "\"filter\": {\"op\": \"starts-with\", \"field\": \"group_key\", " +
                "\"value\": \"1130000034343350:b4b7209d07934bd394d98e31b331d5e79b06fa19b4de4fbdbd3c9c41a3b8699e:document:\", " +
                "\"values\": [\"value1\", \"value2\"]}, " +
                "\"reason\": \"file-changed-or-removed\", \"blockType\": \"content-block\"}";
        FindAndDeleteOrUpdateLentaBlocksTask.Parameters parameters = parser.parseJson(parametersJson);
        Assert.assertNotNull(parameters);
        Assert.assertTrue(parameters.active.filter.values.isPresent());
        SetF<String> values = parameters.active.filter.values.get();
        Assert.assertTrue(values.containsTs("value1"));
        Assert.assertTrue(values.containsTs("value2"));
    }
}
