package ru.yandex.chemodan.app.lentaloader.worker.tasks;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.lentaloader.worker.LentaOnetimeTaskSupport;
import ru.yandex.commune.bazinga.BazingaUtils;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;

/**
 * @author dbrylev
 */
public class HolderForUpdateAndUpOrDeleteTask extends LentaOnetimeTaskSupport<ModifyBlockTaskSupport.ActiveUidParams> {
    public HolderForUpdateAndUpOrDeleteTask(DataApiUserId uid, String blockId) {
        super(new ModifyBlockTaskSupport.ActiveUidParams(uid, blockId));
    }

    public HolderForUpdateAndUpOrDeleteTask() {
        super(ModifyBlockTaskSupport.ActiveUidParams.class);
    }

    @Override
    public TaskId id() {
        return new TaskId(BazingaUtils.simpleClassNameToTaskId(UpdateAndUpOrDeleteLentaBlockTask.class) + ".holder");
    }

    @Override
    protected void doExecute(ModifyBlockTaskSupport.ActiveUidParams parameters, ExecutionContext context) {
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(1);
    }
}
