package ru.yandex.chemodan.app.lentaloader.worker.tasks;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.lentaloader.blocks.ContentBlockManager;
import ru.yandex.chemodan.app.lentaloader.blocks.FolderCreationBlockManager;
import ru.yandex.chemodan.app.lentaloader.blocks.ResourceBlockManager;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaManager;
import ru.yandex.chemodan.app.lentaloader.lenta.limit.LentaLimitManager;
import ru.yandex.chemodan.app.lentaloader.worker.LentaCronTaskWrapper;
import ru.yandex.commune.bazinga.BazingaConfiguration;
import ru.yandex.commune.bazinga.BazingaConfigurator;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.tasks.BazingaHeartbeatTask;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author dbrylev
 */
@Configuration
public class LentaWorkerTasksContextConfiguration {

    @Bean
    public CronTask bazingaHeartbeatTask(BazingaConfiguration bazingaConfiguration, ZkManager zkManager) {
        return new LentaCronTaskWrapper(new BazingaHeartbeatTask(
                bazingaConfiguration,
                BazingaConfigurator.zkBazingaConfigurationStorage(bazingaConfiguration, zkManager)))
        {
            public TaskId id() {
                return new TaskId("bazingaHeartbeat.lenta");
            }
        };
    }

    @Bean
    public DeleteEmptyLentaBlockTask deleteEmptyLentaBlockTask(
            LentaManager lentaManager, ContentBlockManager contentBlockManager,
            ResourceBlockManager resourceBlockManager)
    {
        return new DeleteEmptyLentaBlockTask(lentaManager,
                contentBlockManager,
                resourceBlockManager);
    }

    @Bean
    public DeleteOrUpdateLentaBlockTask deleteOrUpdateLentaBlockTask(
            LentaManager lentaManager, ContentBlockManager contentBlockManager,
            FolderCreationBlockManager folderCreationBlockManager)
    {
        return new DeleteOrUpdateLentaBlockTask(
                lentaManager, contentBlockManager, folderCreationBlockManager);
    }

    @Bean
    public UpdateAndUpOrDeleteLentaBlockTask updateAndUpOrDeleteLentaBlockTask(
            LentaManager lentaManager, ContentBlockManager contentBlockManager)
    {
        return new UpdateAndUpOrDeleteLentaBlockTask(lentaManager, contentBlockManager);
    }

    @Bean
    public HolderForUpdateAndUpOrDeleteTask holderForUpdateAndUpOrDeleteTask() {
        return new HolderForUpdateAndUpOrDeleteTask();
    }

    @Bean
    public UnpinLentaBlockTask unpinLentaBlockTask(LentaManager lentaManager) {
        return new UnpinLentaBlockTask(lentaManager);
    }

    @Bean
    public FindAndDeleteOrUpdateLentaBlocksTask findAndDeleteOrUpdateLentaBlocksTask(LentaManager lentaManager) {
        return new FindAndDeleteOrUpdateLentaBlocksTask(lentaManager);
    }

    @Bean
    public CleanupLentaBlocksCronTask cleanupLentaBlocksCronTask(
            DiskDataSource nativeDataApiManager, LentaManager lentaManager)
    {
        return new CleanupLentaBlocksCronTask(nativeDataApiManager, lentaManager);
    }

    @Bean
    public CleanupLentaBlockCreaturesTask cleanupLentaBlockCreaturesTask(
            LentaLimitManager lentaLimitManager)
    {
        return new CleanupLentaBlockCreaturesTask(lentaLimitManager);
    }

    @Bean
    public MergeContentLentaBlocksTask mergeContentLentaBlocksTask(
            LentaLimitManager lentaLimitManager)
    {
        return new MergeContentLentaBlocksTask(lentaLimitManager);
    }
}
