package ru.yandex.chemodan.app.lentaloader.worker.tasks;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.lentaloader.lenta.limit.LentaLimitManager;
import ru.yandex.chemodan.app.lentaloader.worker.LentaOnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
public abstract class LimitBlocksTaskSupport extends LentaOnetimeTaskSupport<LimitBlocksTaskSupport.Parameters> {

    protected LentaLimitManager lentaLimitManager;

    public LimitBlocksTaskSupport(DataApiUserId uid) {
        super(new Parameters(uid));
    }

    public LimitBlocksTaskSupport(LentaLimitManager lentaLimitManager) {
        super(Parameters.class);
        this.lentaLimitManager = lentaLimitManager;
    }

    protected abstract void execute(DataApiUserId uid) throws Exception;

    @Override
    protected void doExecute(LimitBlocksTaskSupport.Parameters params, ExecutionContext context) throws Exception {
        execute(params.uid);
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @BenderBindAllFields
    public static class Parameters {
        public final DataApiUserId uid;

        public Parameters(DataApiUserId uid) {
            this.uid = uid;
        }
    }
}
