package ru.yandex.chemodan.app.lentaloader.worker.tasks;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.lentaloader.lenta.limit.LentaLimitManager;
import ru.yandex.commune.bazinga.scheduler.schedule.CompoundReschedulePolicy;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleExponential;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;

/**
 * @author dbrylev
 */
public class MergeContentLentaBlocksTask extends LimitBlocksTaskSupport {

    public MergeContentLentaBlocksTask(DataApiUserId uid) {
        super(uid);
    }

    public MergeContentLentaBlocksTask(LentaLimitManager lentaLimitManager) {
        super(lentaLimitManager);
    }

    @Override
    protected void execute(DataApiUserId uid) {
        lentaLimitManager.mergeContentBlocks(uid, getActionInfo());
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new CompoundReschedulePolicy(
                new RescheduleConstant(Duration.standardMinutes(1), 10),
                new RescheduleExponential(Duration.standardMinutes(1), 10));
    }
}
