package ru.yandex.chemodan.app.lentaloader.worker.tasks;

import javax.annotation.Nullable;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaManager;
import ru.yandex.chemodan.app.lentaloader.log.ActionInfo;
import ru.yandex.chemodan.app.lentaloader.log.ActionReason;
import ru.yandex.chemodan.app.lentaloader.worker.LentaOnetimeTaskSupport;
import ru.yandex.chemodan.http.YandexCloudRequestIdHolder;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.support.tl.ThreadLocalHandle;

/**
 * @author dbrylev
 */
public abstract class ModifyBlockTaskSupport extends LentaOnetimeTaskSupport<ModifyBlockTaskSupport.Parameters> {
    protected LentaManager lentaManager;

    public ModifyBlockTaskSupport(
            DataApiUserId uid, String blockId, Option<ActionReason> reason, Option<ActionInfo> actionInfo)
    {
        super(new Parameters(
                new ActiveUidParams(uid, blockId),
                new ActionInfoParameters(
                        YandexCloudRequestIdHolder.getO(),
                        actionInfo.flatMapO(ActionInfo::getActionEvent), reason)));
    }

    public ModifyBlockTaskSupport(LentaManager lentaManager) {
        super(Parameters.class);
        this.lentaManager = lentaManager;
    }

    protected abstract void execute(
            DataApiUserId uid, String blockId, Option<ActionReason> reason, ExecutionContext context) throws Exception;

    @Override
    protected void doExecute(Parameters params, ExecutionContext context) throws Exception {
        Option<ThreadLocalHandle> handler = params.info.ycrid.map(YandexCloudRequestIdHolder::setAndPushToNdc);
        try {
            execute(params.active.uid, params.active.blockId, params.info.reason, context);

        } finally {
            handler.forEach(ThreadLocalHandle::popSafely);
        }
    }

    @Override
    protected ActionInfo getActionInfo() {
        return getParametersTyped().info.getActionInfo(super.getActionInfo());
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(1);
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return ActiveUidParams.Converter.class;
    }

    @BenderBindAllFields
    public static class Parameters {
        @BenderFlatten
        public final ActiveUidParams active;
        @BenderFlatten
        public final ActionInfoParameters info;

        public Parameters(ActiveUidParams active, ActionInfoParameters info) {
            this.active = active;
            this.info = info;
        }
    }

    @BenderBindAllFields
    public static class ActiveUidParams {
        public final DataApiUserId uid;
        public final String blockId;

        public ActiveUidParams(DataApiUserId uid, String blockId) {
            this.uid = uid;
            this.blockId = blockId;
        }

        public static class Converter implements ActiveUniqueIdentifierConverter<Parameters, ActiveUidParams> {
            @Override
            public Class<ActiveUidParams> getActiveUniqueIdentifierClass() {
                return ActiveUidParams.class;
            }

            @Override
            public ActiveUidParams convert(Parameters parameters) {
                return parameters.active;
            }
        }
    }
}
