package ru.yandex.chemodan.app.lentaloader.worker.tasks;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaManager;
import ru.yandex.chemodan.app.lentaloader.log.ActionReason;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;

/**
 * @author dbrylev
 */
public class UnpinLentaBlockTask extends ModifyBlockTaskSupport {

    public UnpinLentaBlockTask(DataApiUserId uid, String blockId) {
        super(uid, blockId, Option.empty(), Option.empty());
    }

    public UnpinLentaBlockTask(LentaManager lentaManager) {
        super(lentaManager);
    }

    @Override
    protected void execute(
            DataApiUserId uid, String blockId, Option<ActionReason> reason, ExecutionContext context) throws Exception
    {
        lentaManager.unpinBlockIfPinned(uid, blockId, getActionInfo());
    }
}
