package ru.yandex.chemodan.app.lentaloader.worker.tasks;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.lentaloader.blocks.ContentBlockFields;
import ru.yandex.chemodan.app.lentaloader.blocks.ContentBlockManager;
import ru.yandex.chemodan.app.lentaloader.blocks.PublicResourceBlockFields;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaBlockRecord;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaManager;
import ru.yandex.chemodan.app.lentaloader.lenta.LentaRecordType;
import ru.yandex.chemodan.app.lentaloader.lenta.update.LentaBlockBaseData;
import ru.yandex.chemodan.app.lentaloader.lenta.update.UpdateOrDeleteHandler;
import ru.yandex.chemodan.app.lentaloader.log.ActionInfo;
import ru.yandex.chemodan.app.lentaloader.log.ActionReason;
import ru.yandex.chemodan.app.lentaloader.log.DataOrRefusal;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;

/**
 * @author dbrylev
 */
public class UpdateAndUpOrDeleteLentaBlockTask extends ModifyBlockTaskSupport {

    private ContentBlockManager contentBlockManager;

    public UpdateAndUpOrDeleteLentaBlockTask(DataApiUserId uid, String blockId, ActionInfo actionInfo) {
        super(uid, blockId, Option.empty(), Option.of(actionInfo));
    }

    public UpdateAndUpOrDeleteLentaBlockTask(
            LentaManager lentaManager,
            ContentBlockManager contentBlockManager)
    {
        super(lentaManager);
        this.contentBlockManager = contentBlockManager;
    }

    @Override
    protected void execute(DataApiUserId uid, String blockId, Option<ActionReason> reason, ExecutionContext context) throws Exception {
        lentaManager.updateOrDeleteBlock(uid, blockId, record -> {
            if (record.type == LentaRecordType.CONTENT_BLOCK) {
                return processContentBlock(uid, record);

            } else if (record.type == LentaRecordType.PUBLIC_RESOURCE) {
                return modify(record, Cf.map(PublicResourceBlockFields.MY_ACTION.name, DataField.nul()));

            } else {
                return modify(record, Cf.map());
            }
        }, getActionInfo());
    }

    private UpdateOrDeleteHandler.Action processContentBlock(DataApiUserId uid, LentaBlockRecord record) {
        DataOrRefusal<Integer> filesCount = contentBlockManager.getFilesCount(uid, record);

        if (!filesCount.isRefusal()) {
            return modify(record, Cf.toMap(Option.of(ContentBlockFields.FILES_COUNT.toData(filesCount.getData()))));
        } else {
            return UpdateOrDeleteHandler.delete(filesCount.getRefusalReason());
        }
    }

    private UpdateOrDeleteHandler.Action modify(
            LentaBlockRecord record, MapF<String, DataField> updateData)
    {
        ListF<String> nullKeys = updateData.entrySet()
                .filterMap(e -> Option.when(e.getValue().value == null, e.getKey()));

        return UpdateOrDeleteHandler.updateAndUp(
                new LentaBlockBaseData(record.type, record.groupKey),
                record.toData().plus(updateData).filterKeys(k -> !nullKeys.containsTs(k)));
    }
}
