package ru.yandex.chemodan.app.lentaworker;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.lentaloader.LentaCoreContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.cool.CoolLentaCoreContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.cool.worker.CoolLentaWorkerContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.memories.MemoriesContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.reminder.PhotoReminderContextConfiguration;
import ru.yandex.chemodan.app.lentaloader.worker.tasks.LentaWorkerTasksContextConfiguration;
import ru.yandex.chemodan.bazinga.dynamic.DynamicCronTasksAdminPage;
import ru.yandex.chemodan.bazinga.dynamic.DynamicCronTasksContextConfiguration;
import ru.yandex.chemodan.bazinga.dynamic.DynamicCronTasksManager;
import ru.yandex.chemodan.queller.worker.CeleryTaskManagerContextConfiguration;
import ru.yandex.commune.admin.web.AdminApp;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        LentaCoreContextConfiguration.class,
        ru.yandex.chemodan.app.lentaloader.worker.LentaWorkerContextConfiguration.class,
        LentaWorkerTasksContextConfiguration.class,
        CeleryTaskManagerContextConfiguration.class,
        PhotoReminderContextConfiguration.class,
        DynamicCronTasksContextConfiguration.class,
        MemoriesContextConfiguration.class,
        CoolLentaWorkerContextConfiguration.class,
        CoolLentaCoreContextConfiguration.class
})
public class LentaWorkerContextConfiguration {

    @Bean
    public DynamicCronTasksAdminPage dynamicCronTasksAdminPage(AdminApp adminApp, DynamicCronTasksManager dynamicCronTasksManager) {
        DynamicCronTasksAdminPage page = new DynamicCronTasksAdminPage(dynamicCronTasksManager);

        adminApp.registerAdminPage("", Option.of("Bazinga Cron"), page);

        return page;
    }
}
