package ru.yandex.chemodan.app.logreader;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.logreader.accesslog.MpfsLogReaderCountersContextConfiguration;
import ru.yandex.chemodan.app.logreader.event_history.MpfsEventHistoryLogContextConfiguration;
import ru.yandex.chemodan.app.logreader.preview.MpfsLogReaderPreviewContextConfiguration;
import ru.yandex.chemodan.boot.DiskAppVersion;
import ru.yandex.chemodan.uploader.docviewer.DocviewerContextConfiguration;
import ru.yandex.chemodan.zk.registries.tvm.ZkTvm2ContextConfiguration;
import ru.yandex.commune.dynproperties.admin.DynamicPropertiesAdminContextConfiguration;
import ru.yandex.misc.version.Version;

/**
 * @author akirakozov
 */
@Configuration
@Import({
        MpfsLogReaderCountersContextConfiguration.class,
        MpfsLogReaderPreviewContextConfiguration.class,
        MpfsEventHistoryLogContextConfiguration.class,
        DynamicPropertiesAdminContextConfiguration.class,
        DocviewerContextConfiguration.class,
        ZkTvm2ContextConfiguration.class
})
public class MpfsLogReaderContextConfiguration {

    @Bean
    public Version version() {
        return DiskAppVersion.VERSION;
    }
}
