package ru.yandex.chemodan.app.logreader;

import org.springframework.context.ConfigurableApplicationContext;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.misc.log.mlf.Level;
import ru.yandex.misc.property.PropertiesHolder;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author akirakozov
 */
public class MpfsLogReaderMain extends ChemodanMainSupport {

    public static void main(String[] args) {
        new MpfsLogReaderMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("disk", "log-reader");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(
                ChemodanCommonContextConfiguration.class,
                MpfsLogReaderContextConfiguration.class);
    }

    @Override
    protected void configureLogger() {
        super.configureLogger();

        Log4jHelper.configureAliveAppsLoggerLevel(Level.INFO);
    }

    @Override
    protected void postProcessApplicationContextBeforeRefresh(ConfigurableApplicationContext context) {
        super.postProcessApplicationContextBeforeRefresh(context);

        Cf.list("counters", "preview", "event-history")
                .filter(this::isPropertyEnabled)
                .forEach(profileName -> context.getEnvironment().addActiveProfile(profileName));
    }

    private boolean isPropertyEnabled(String profileName) {
        return Boolean.valueOf(PropertiesHolder.properties().getProperty("log-reader." + profileName + ".enabled"));
    }
}
