package ru.yandex.chemodan.app.logreader.accesslog;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

import ru.yandex.chemodan.app.countersapi.CassandraContextConfiguration;
import ru.yandex.chemodan.app.logreader.util.LogReaderFactory;
import ru.yandex.commune.salr.logreader.LogReader;
import ru.yandex.misc.io.file.File2;

/**
 * @author nshmakov
 */
@Profile("counters")
@Configuration
@Import(CassandraContextConfiguration.class)
public class MpfsLogReaderCountersContextConfiguration {

    @Bean
    public MpfsPublicInfoLogListener mpfsPublicInfoLogListener() {
        return new MpfsPublicInfoLogListener();
    }

    @Bean
    public LogReader mpfsAccessLogReader(
            @Value("${mpfs.accessLog.file}")
            File2 accessLog,
            @Value("${mpfs.accessLog.state}")
            File2 stateFile,
            MpfsPublicInfoLogListener logListener,
            @Value("${log-reader.max-log-line-data-size}")
            int maxLogLineDataSize)
    {
        return LogReaderFactory.createLogReader(accessLog, stateFile, logListener, maxLogLineDataSize);
    }

}
