package ru.yandex.chemodan.app.logreader.accesslog;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.countersapi.dao.PublicPageViewsDao;
import ru.yandex.chemodan.util.tskv.TskvUtils;
import ru.yandex.commune.salr.logreader.LogListener;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author nshmakov
 */
public class MpfsPublicInfoLogListener implements LogListener {

    private static final Logger log = LoggerFactory.getLogger(MpfsPublicInfoLogListener.class);

    @Autowired
    private PublicPageViewsDao publicPageViewsDao;

    public void processLogLine(String line) {
        MapF<String, String> m = TskvUtils.extractTskv(line);

        if (!m.containsKeyTs("uri") || !m.containsKeyTs("status")) {
            log.warn("Incorrect log line format: " + line);
            return;
        }

        String relativeUrl = m.getTs("uri");
        String responseCode = m.getTs("status");

        if (is2xx(responseCode)) {
            if (relativeUrl.startsWith("/json/public_info") && relativeUrl.contains("increment_views=1")) {
                procesPublicInfo(relativeUrl);
            } else if (relativeUrl.startsWith("/json/public_album_get") && relativeUrl.contains("increment_views=1")) {
                processPublicAlbumGet(relativeUrl);
            }
        }
    }

    private void procesPublicInfo(String relativeUrl) {
        Option<String> hashO = UrlUtils.getQueryParameterFromUrl(relativeUrl, "private_hash");
        if (hashO.isPresent()) {
            String hash = hashO.get();
            if (isPublicFolderFile(hash)) {
                return;
            }
            log.debug("Increment counter for public link with hash {}", hash);
            publicPageViewsDao.increaseCounter(hash, 1);
        }
    }

    private void processPublicAlbumGet(String relativeUrl) {
        Option<String> publicKeyO = UrlUtils.getQueryParameterFromUrl(relativeUrl, "public_key");
        if (publicKeyO.isPresent()) {
            log.debug("Increment counter for public album with key {}", publicKeyO.get());
            publicPageViewsDao.increaseCounter(publicKeyO.get(), 1);
        }
    }

    private boolean is2xx(String responseCode) {
        return responseCode.startsWith("2");
    }

    private boolean isPublicFolderFile(String hash) {
        return hash.split(":").length > 1;
    }

    public void setPublicPageViewsDao(PublicPageViewsDao publicPageViewsDao) {
        this.publicPageViewsDao = publicPageViewsDao;
    }
}
