package ru.yandex.chemodan.app.logreader.event_history;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import ru.yandex.chemodan.app.logreader.util.LogReaderFactory;
import ru.yandex.chemodan.uploader.docviewer.DocviewerClient;
import ru.yandex.commune.salr.logreader.LogReader;
import ru.yandex.misc.io.file.File2;

/**
 * @author akirakozov
 */
@Profile("event-history")
@Configuration
public class MpfsEventHistoryLogContextConfiguration {

    @Bean
    public MpfsEventHistoryLogListener mpfsEventHistoryLogListener(DocviewerClient docviewerClient) {
        return new MpfsEventHistoryLogListener(docviewerClient);
    }

    @Bean
    public LogReader mpfsEventHistoryLogReader(
            MpfsEventHistoryLogListener logListener,
            @Value("${mpfs.event-history.log}")
            File2 accessLog,
            @Value("${mpfs.event-history.log.state.file}")
            File2 stateFile,
            @Value("${log-reader.max-log-line-data-size}")
            int maxLogLineDataSize)
    {
        return LogReaderFactory.createLogReader(accessLog, stateFile, logListener, maxLogLineDataSize);
    }

}
