package ru.yandex.chemodan.app.logreader.preview;

import org.joda.time.Instant;
import org.junit.Test;

import ru.yandex.chemodan.core.worker.tasks.RegeneratePreviewParameters;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.test.Assert;
import ru.yandex.misc.test.TestBase;

/**
 * @author akirakozov
 */
public class MpfsPreviewLogListenerTest extends TestBase {

    @Test
    public void extractParameters() {
        String line = "2013-10-04 03:14:49,222 [8594] web-0e2e2a07f2f3d110452aea8a3ed00207-ufodev 8594_11567 disk uid: share_test "
                + "hid: 64930fdc10d0785ff725af6974fb6418 "
                + "stid: 1000007.yadisk:share_test.398329638470720924662700818635 "
                + "mimetype: application/x-msdownload size: 8693536 "
                + "mtime: 123456 "
                + "utime: 123456 "
                + "path: /disk/test/tes1/%D0%9C%D0%BE%D0%B9%20%D1%84%D0%B0%D0%B9%D0%BB";

        String requestId = MpfsPreviewLogListener.extractMpfsRequestId(line);

        Assert.equals("8594_11567", requestId);
        Assert.isFalse(MpfsPreviewLogListener.isQueueRequestId(requestId));
        Assert.isTrue(MpfsPreviewLogListener.isQueueRequestId("526c4b00bf7e414bfcbe8b85"));

        RegeneratePreviewParameters params = MpfsPreviewLogListener.extractRegeneratePreviewParameters(line);
        Assert.equals(
                new RegeneratePreviewParameters(
                        "share_test",
                        "64930fdc10d0785ff725af6974fb6418",
                        MulcaId.fromSerializedString("1000007.yadisk:share_test.398329638470720924662700818635"),
                        "application/x-msdownload",
                        8693536,
                        "/disk/test/tes1/Мой файл",
                        new Instant(123456000),
                        new Instant(123456000)), params);

        Assert.equals("Мой файл", params.getFilename());
        Assert.equals(16, MpfsPreviewLogListener.decodeHid(params.hid).length);
    }
}
