package ru.yandex.chemodan.app.logreader.util;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.salr.logreader.LogListener;
import ru.yandex.commune.salr.logreader.LogReader;
import ru.yandex.misc.io.file.File2;

/**
 * @author akirakozov
 */
public class LogReaderFactory {

    public static LogReader createLogReader(
            File2 logFile, File2 stateFile, LogListener logListener, int maxLogLineDataSize)
    {
        LogReader logReader = new LogReader(Option.of(maxLogLineDataSize));
        logReader.setLogFile(logFile);
        logReader.setLogListener(logListener);
        logReader.setLogStateFile(stateFile);
        return logReader;
    }

}
