package ru.yandex.chemodan.app.migrator;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.migrator.logging.MigrationEventsLogger;
import ru.yandex.chemodan.app.migrator.migration.MigratorContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.misc.db.monica.JdbcMetricsSwitch;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author yashunsky
 */
public class MigratorMain extends ChemodanMainSupport {

    public static void main(String[] args) {
        JdbcMetricsSwitch.ENABLED = true;
        JdbcMetricsSwitch.COMMAND_METRICS_ENABLED = true;
        new MigratorMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("disk", "migrator");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(
                ChemodanCommonContextConfiguration.class,
                MigratorContextConfiguration.class
        );
    }

    @Override
    protected void configureLogger() {
        super.configureLogger();

        Log4jHelper.appenderBuilder()
                .appName(applicationName())
                .name(MigrationEventsLogger.getName())
                .postfix("-events")
                .layout(MigrationEventsLogger.getPatternLayout())
                .build();
    }

}
