package ru.yandex.chemodan.app.migrator.logging;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.migrator.tasks.MigrationParameters;
import ru.yandex.chemodan.log.TskvLogPatternLayout;
import ru.yandex.chemodan.log.TskvLogger;

/**
 * @author yashunsky
 */
public class MigrationEventsLogger {
    private static final String NAME = "migration-events";
    private static final TskvLogger logger = new TskvLogger(NAME);
    private static final TskvLogPatternLayout patternLayout =
            new TskvLogPatternLayout("ydisk-migration-events-log", false, true);

    public static String getName() {
        return logger.name;
    }

    public static TskvLogPatternLayout getPatternLayout() {
        return patternLayout;
    }

    public void log(String sharpeiHost, MigrationParameters parameters, MigrationStageStatus status) {
        logger.log(parameters.getLogParams().toTupleList()
                .plus(Tuple2List.fromPairs("status", status, "sharpeiHost", sharpeiHost)).map2(String::valueOf));
    }
}
