package ru.yandex.chemodan.app.migrator.logging;

import lombok.Data;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;

/**
 * @author yashunsky
 */
@Data
public class MigrationStageLogParametersImpl implements MigrationStageLogParameters{
    private final DataApiUserId uid;
    private final String stage;
    private final Tuple2List<String, Object> customParams;

    public MigrationStageLogParametersImpl(DataApiUserId uid, String stage, Object... customParams)
    {
        this.uid = uid;
        this.stage = stage;
        this.customParams = Tuple2List.fromPairs(customParams).map1(String::valueOf);
    }

    @Override
    public Tuple2List<String, Object> toTupleList() {
        return customParams.plus(Tuple2List.fromPairs("uid", uid, "stage", stage));
    }
}
