package ru.yandex.chemodan.app.migrator.logging;

import ru.yandex.chemodan.app.migrator.migration.MigrationResult;

/**
 * @author yashunsky
 */
public enum MigrationStageStatus {
    STARTED,
    DONE,
    SKIPPED,
    ABORTED,
    FAILED;

    public static MigrationStageStatus fromMigrationResult(MigrationResult migrationResult) {
        if (migrationResult instanceof MigrationResult.Done) {
            return DONE;
        } else if (migrationResult instanceof MigrationResult.Skipped) {
            return SKIPPED;
        } else if (migrationResult instanceof MigrationResult.Aborted) {
            return ABORTED;
        } else if (migrationResult instanceof MigrationResult.CleaningDone) {
            return DONE;
        } else if (migrationResult instanceof MigrationResult.CleaningAborted) {
            return ABORTED;
        }

        throw new RuntimeException("Unknown migration result " + migrationResult.getClass());
    }
}
