package ru.yandex.chemodan.app.migrator.migration;

import ru.yandex.misc.bytes.ByteArrayByteSequence;
import ru.yandex.misc.digest.Sha256;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author yashunsky
 */

public class MigrationDigester {
    private final Sha256.Stream sha256;

    public MigrationDigester() {
        this.sha256 = Sha256.A.stream();
    }

    private void append(byte[] bytes) {
        sha256.update(new ByteArrayByteSequence(bytes, 0, bytes.length));
    }

    public void append(DefaultObject object) {
        append(object.toString().getBytes());
    }

    public Sha256.Sum end() {
        return sha256.end();
    }
}
