package ru.yandex.chemodan.app.migrator.migration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.impl.AbstractPrefetchingIterator;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.migration.MigrationSupport;
import ru.yandex.chemodan.ratelimiter.chunk.ChunkRateLimiter;

/**
 * @author yashunsky
 */
public abstract class MigrationShardIterator<T> extends AbstractPrefetchingIterator<ListF<T>> {
    protected final DataApiUserId uid;
    private final int primaryShardId;
    private final Option<Integer> secondaryShardId;
    protected final ChunkRateLimiter rateLimiter;

    public MigrationShardIterator(
            DataApiUserId uid, int primaryShardId, Option<Integer> secondaryShardId,
            ChunkRateLimiter rateLimiter)
    {
        this.uid = uid;
        this.primaryShardId = primaryShardId;
        this.secondaryShardId = secondaryShardId;
        this.rateLimiter = rateLimiter;
    }

    /* Make sure the implementation returns records in a definite order, otherwise consistency check may fail */
    abstract ListF<T> getDataInner();

    abstract void updateLimits(ListF<T> data);

    @Override
    protected Option<ListF<T>> fetchNext() {
        ListF<T> data = MigrationSupport.getWithOptionalConsistencyCheck(
                uid, primaryShardId, secondaryShardId, this::getDataInner);

        updateLimits(data);

        return Option.when(data.isNotEmpty(), data);
    }
}
