package ru.yandex.chemodan.app.migrator.migration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChangeType;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoIgnoreField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author yashunsky
 */
@BenderBindAllFields
@ProtoMessage
public class OldStyleDelta extends DefaultObject {
    @ProtoField(n = 1)
    public final ListF<OldStyleRecordChange> changes;
    @ProtoField(n = 2)
    public final Option<String> id;
    @ProtoField(n = 3)
    public final Option<Long> rev;
    @ProtoField(n = 4)
    public final Option<Long> newRev;

    @ProtoIgnoreField
    @BenderIgnore
    public final transient boolean extra;

    public OldStyleDelta(Delta delta) {
        this.changes = delta.changes.map(OldStyleRecordChange::new);
        this.id = delta.id;
        this.rev = delta.rev;
        this.newRev = delta.newRev;
        this.extra = delta.extra;
    }

    @Override
    public String toString() {
        return super.toString().replaceFirst("OldStyle", "");
    }

    @ProtoMessage
    private static class OldStyleRecordChange extends DefaultObject {
        @ProtoField(n = 1)
        public final RecordChangeType type;
        @ProtoField(n = 2)
        public final String collectionId;
        @ProtoField(n = 3)
        public final String recordId;
        @ProtoField(n = 4)
        public final ListF<FieldChange> fieldChanges;

        public OldStyleRecordChange(RecordChange change) {
            this.type = change.type;
            this.collectionId = change.collectionId;
            this.recordId = change.recordId;
            this.fieldChanges = change.fieldChanges;
        }

        @Override
        public String toString() {
            return super.toString().replaceFirst("OldStyleDelta.OldStyle", "");
        }
    }
}
