package ru.yandex.chemodan.app.migrator.sharpei.cleanup;

import lombok.AllArgsConstructor;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author yashunsky
 */
@AllArgsConstructor
public class SharpeiCleanupDao {
    private static final Logger logger = LoggerFactory.getLogger(SharpeiCleanupDao.class);

    private final SharpeiCleanupControl control;

    private final JdbcTemplate3 jdbcTemplate;

    public boolean delete(DataApiUserId uid, boolean withRo) {
        if (!control.cleanupEnable()) {
            logger.error("Sharpei cleanup disabled");
            return false;
        }

        String query = "DELETE FROM shards." +
                (uid.isPassportUid() ? "users" : "text_users") +
                " WHERE uid = ?" + (withRo ? " AND data = '{\"r\": 1}'" : "");

        return jdbcTemplate.update(query, uid.toString()) > 0;
    }
}
