package ru.yandex.chemodan.app.migrator.sharpei.cleanup;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfigurator;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfiguratorContextConfiguration;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author yashunsky
 */
@Configuration
@Import({
        JdbcDatabaseConfiguratorContextConfiguration.class,
})
public class SharpeiJdbcContextConfiguration {

    @Autowired
    private JdbcDatabaseConfiguratorContextConfiguration dbConfiguratorConfig;


    @OverridableValuePrefix("sharpei")
    @Bean
    public DataSourceProperties sharpeiDatasourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    public JdbcDatabaseConfigurator sharpeiDbConfigurator(
            @Qualifier("sharpeiDatasourceProperties") DataSourceProperties orchestratorDataSourceProperties)
    {
        return dbConfiguratorConfig.consJdbcConfigurator(orchestratorDataSourceProperties);
    }

    @Bean
    public DataSource sharpeiDataSource(@Qualifier("sharpeiDbConfigurator") JdbcDatabaseConfigurator sharpeiDbConfigurator)
    {
        return sharpeiDbConfigurator.configureDataSource();
    }

    @Bean
    public JdbcTemplate3 sharpeiJdbcTemplate(@Qualifier("sharpeiDbConfigurator") JdbcDatabaseConfigurator sharpeiCleanupDbConfigurator,
                                             @Qualifier("sharpeiDataSource") DataSource sharpeiDataSource)
    {
        return sharpeiCleanupDbConfigurator.consTemplate(sharpeiDataSource);
    }

    @Bean
    public SharpeiCleanupDao sharpeiCleanupDao(SharpeiCleanupControl control,
                                               @Qualifier("sharpeiJdbcTemplate") JdbcTemplate3 sharpeiJdbcTemplate )
    {
        return new SharpeiCleanupDao(control, sharpeiJdbcTemplate);
    }
}
