package ru.yandex.chemodan.app.migrator.tasks;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.migrator.MigratorTaskQueueName;
import ru.yandex.chemodan.app.migrator.control.BazingaDatasyncUserMigrationManager;
import ru.yandex.chemodan.app.migrator.logging.MigrationStageLogParameters;
import ru.yandex.chemodan.app.migrator.logging.MigrationStageLogParametersImpl;
import ru.yandex.chemodan.app.migrator.logging.MigrationStageStatus;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
public class DatasyncMigrationCleanUpTask extends
        DatasyncMigrationTaskSupport<DatasyncMigrationCleanUpTask.Parameters>
{

    public DatasyncMigrationCleanUpTask(DataApiUserId uid, int shardId, String hash, String sharpeiId) {
        super(new Parameters(uid, shardId, Option.of(hash)), sharpeiId);
    }

    public DatasyncMigrationCleanUpTask(DataApiUserId uid, int shardId, String sharpeiId) {
        super(new Parameters(uid, shardId, Option.empty()), sharpeiId);
    }

    public DatasyncMigrationCleanUpTask(
            BazingaDatasyncUserMigrationManager bazingaDatasyncUserMigrationManager, String sharpeiId)
    {
        super(Parameters.class, bazingaDatasyncUserMigrationManager, sharpeiId);
    }

    @Override
    protected MigrationStageStatus executeInner(Parameters parameters, ExecutionContext context) throws Exception {
        return bazingaDatasyncUserMigrationManager.cleanUp(parameters.uid, parameters.shard, parameters.hash);
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(1);
    }

    @Override
    public TaskQueueName queueName() {
        return MigratorTaskQueueName.CLEAN_UP;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters implements MigrationParameters {
        private final DataApiUserId uid;
        private final int shard;
        private final Option<String> hash;

        @Override
        public MigrationStageLogParameters getLogParams() {
            return new MigrationStageLogParametersImpl(
                    uid, "cleanUp", "sourceShard", shard, "hash", hash.getOrElse("fallbackCleaning"));
        }

        @Override
        public ListF<Integer> getRequiredShards() {
            return Cf.list(shard);
        }
    }
}
