package ru.yandex.chemodan.app.migrator.tasks;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.migrator.control.BazingaDatasyncUserMigrationManager;
import ru.yandex.chemodan.app.migrator.logging.MigrationStageLogParameters;
import ru.yandex.chemodan.app.migrator.logging.MigrationStageLogParametersImpl;
import ru.yandex.chemodan.app.migrator.logging.MigrationStageStatus;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author yashunsky
 */
public class DatasyncMigrationLockTask extends DatasyncMigrationTaskSupport<DatasyncMigrationLockTask.Parameters> {
    private static final Logger logger = LoggerFactory.getLogger(DatasyncMigrationLockTask.class);

    public DatasyncMigrationLockTask(DataApiUserId uid, String sharpeiId) {
        super(new Parameters(uid), sharpeiId);
    }

    public DatasyncMigrationLockTask(
            BazingaDatasyncUserMigrationManager bazingaDatasyncUserMigrationManager, String sharpeiId)
    {
        super(Parameters.class, bazingaDatasyncUserMigrationManager, sharpeiId);
    }

    @Override
    public int priority() {
        return 2;
    }

    @Override
    protected MigrationStageStatus executeInner(Parameters parameters, ExecutionContext context) throws Exception {
        logger.info("Ensuring user {} will not stay read only and removing migration lock", parameters.uid);
        return bazingaDatasyncUserMigrationManager.removeReadOnly(parameters.uid);
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_FINISHED, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(10);
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters implements MigrationParameters {
        private final DataApiUserId uid;

        @Override
        public MigrationStageLogParameters getLogParams() {
            return new MigrationStageLogParametersImpl(uid, "lockRemoval");
        }

        @Override
        public ListF<Integer> getRequiredShards() {
            return Cf.list();
        }
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(5), 100);
    }
}
