package ru.yandex.chemodan.app.migrator.tasks;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.migrator.control.BazingaDatasyncUserMigrationManager;
import ru.yandex.chemodan.app.migrator.logging.MigrationStageLogParameters;
import ru.yandex.chemodan.app.migrator.logging.MigrationStageLogParametersImpl;
import ru.yandex.chemodan.app.migrator.logging.MigrationStageStatus;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
public class DatasyncMigrationLogsCheckTask extends
        DatasyncMigrationTaskSupport<DatasyncMigrationLogsCheckTask.Parameters>
{

    public DatasyncMigrationLogsCheckTask(
            DataApiUserId uid, int sourceShard, Instant migrationTime, String hash, String sharpeiId)
    {
        super(new Parameters(uid, sourceShard, migrationTime, hash), sharpeiId);
    }

    public DatasyncMigrationLogsCheckTask(
            BazingaDatasyncUserMigrationManager bazingaDatasyncUserMigrationManager, String sharpeiId)
    {
        super(Parameters.class, bazingaDatasyncUserMigrationManager, sharpeiId);
    }
    @Override
    protected MigrationStageStatus executeInner(Parameters parameters, ExecutionContext context) throws Exception {
        return bazingaDatasyncUserMigrationManager
                .checkLogs(parameters.uid, parameters.sourceShard, parameters.migrationTime, parameters.hash);
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(1);
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters implements MigrationParameters{
        private final DataApiUserId uid;
        private int sourceShard;
        private Instant migrationTime;
        private final String hash;

        @Override
        public MigrationStageLogParameters getLogParams() {
            return new MigrationStageLogParametersImpl(
                    uid, "logsCheck", "sourceShard", sourceShard, "migrationTime", migrationTime, "hash", hash);
        }

        @Override
        public ListF<Integer> getRequiredShards() {
            return Cf.list();
        }
    }
}
