package ru.yandex.chemodan.app.migrator.tasks;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.migrator.MigratorTaskQueueName;
import ru.yandex.chemodan.app.migrator.control.BazingaDatasyncUserMigrationManager;
import ru.yandex.chemodan.app.migrator.logging.MigrationStageLogParameters;
import ru.yandex.chemodan.app.migrator.logging.MigrationStageLogParametersImpl;
import ru.yandex.chemodan.app.migrator.logging.MigrationStageStatus;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
public class DatasyncMigrationTask extends DatasyncMigrationTaskSupport<DatasyncMigrationTask.Parameters> {

    public DatasyncMigrationTask(DataApiUserId uid, int sourceShard, int destinationShard, String sharpeiId) {
        super(new Parameters(uid, sourceShard, destinationShard), sharpeiId);
    }

    public DatasyncMigrationTask(
            BazingaDatasyncUserMigrationManager bazingaDatasyncUserMigrationManager, String sharpeiId)
    {
        super(Parameters.class, bazingaDatasyncUserMigrationManager, sharpeiId);
    }

    @Override
    protected MigrationStageStatus executeInner(Parameters parameters, ExecutionContext context) throws Exception {
        return bazingaDatasyncUserMigrationManager.migrate(
                parameters.uid, parameters.sourceShard, parameters.destinationShard);
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_FINISHED, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(1);
    }

    @Override
    public TaskQueueName queueName() {
        return MigratorTaskQueueName.MIGRATION;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters implements MigrationParameters{
        private final DataApiUserId uid;
        private final int sourceShard;
        private final int destinationShard;

        @Override
        public MigrationStageLogParameters getLogParams() {
            return new MigrationStageLogParametersImpl(
                    uid, "migration", "sourceShard", sourceShard, "destinationShard", destinationShard);
        }

        @Override
        public ListF<Integer> getRequiredShards() {
            return Cf.list(sourceShard, destinationShard);
        }
    }
}
