package ru.yandex.chemodan.app.migrator.tasks;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.migrator.MigratorTaskQueueName;
import ru.yandex.chemodan.app.migrator.control.BazingaDatasyncUserMigrationManager;
import ru.yandex.chemodan.app.migrator.logging.MigrationStageLogParameters;
import ru.yandex.chemodan.app.migrator.logging.MigrationStageStatus;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
public class DatasyncMigrationYtSupplyTask
        extends DatasyncMigrationTaskSupport<DatasyncMigrationYtSupplyTask.Parameters>
{
    public DatasyncMigrationYtSupplyTask(String path, long lowerIndex, String sharpeiId) {
        super(new DatasyncMigrationYtSupplyTask.Parameters(path, lowerIndex), sharpeiId);
    }

    public DatasyncMigrationYtSupplyTask(
            BazingaDatasyncUserMigrationManager bazingaDatasyncUserMigrationManager, String sharpeiId)
    {
        super(DatasyncMigrationYtSupplyTask.Parameters.class, bazingaDatasyncUserMigrationManager, sharpeiId);
    }

    @Override
    protected MigrationStageStatus executeInner(DatasyncMigrationYtSupplyTask.Parameters parameters,
            ExecutionContext context) throws Exception
    {
        bazingaDatasyncUserMigrationManager.addUsersFromYt(parameters.path, parameters.lowerIndex);
        return MigrationStageStatus.DONE;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(12);
    }

    @Override
    public TaskQueueName queueName() {
        return MigratorTaskQueueName.YT_SUPPLY;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters implements MigrationParameters {
        private final String path;
        private long lowerIndex;

        @Override
        public MigrationStageLogParameters getLogParams() {
            return new YtSupplyLogParameters(path, lowerIndex);
        }

        @Override
        public ListF<Integer> getRequiredShards() {
            return Cf.list();
        }
    }

    @AllArgsConstructor
    private static class YtSupplyLogParameters implements MigrationStageLogParameters {
        private final String path;
        private final long lowerIndex;

        @Override
        public Tuple2List<String, Object> toTupleList() {
            return Tuple2List.fromPairs("stage", "ytSupply", "path", path, "offset", lowerIndex);
        }
    }
}
