package ru.yandex.chemodan.app.migrator.tasks;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.migrator.MigratorTaskQueueName;
import ru.yandex.chemodan.app.migrator.control.BazingaSharpeiCleanupManager;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
public class SharpeiCleanupTask extends OnetimeTaskSupport<SharpeiCleanupTask.Parameters> {

    private final BazingaSharpeiCleanupManager cleanupManager;
    private final String sharpeiId;

    public SharpeiCleanupTask(DataApiUserId uid, Option<Boolean> withRo, String sharpeiId) {
        super(new Parameters(uid, withRo));
        this.cleanupManager = null;
        this.sharpeiId = sharpeiId;
    }

    public SharpeiCleanupTask(BazingaSharpeiCleanupManager cleanupManager, String sharpeiId) {
        super(Parameters.class);
        this.cleanupManager = cleanupManager;
        this.sharpeiId = sharpeiId;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        if (parameters.getRo()) {
            cleanupManager.removeIfNoData(parameters.getUid());
        } else {
            cleanupManager.fastRemoveIfNoData(parameters.getUid());
        }
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    public TaskQueueName queueName() {
        return MigratorTaskQueueName.SHARPEI_CLEAN_UP;
    }

    @Override
    public TaskId id() {
        return new TaskId(super.id().getId() + "_" + sharpeiId);
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final DataApiUserId uid;
        private final Option<Boolean> ro;

        public boolean getRo() {
            return ro.orElse(true);
        }
    }

}
