package ru.yandex.chemodan.app.migrator.tasks;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.migrator.MigratorTaskQueueName;
import ru.yandex.chemodan.app.migrator.control.BazingaSharpeiCleanupManager;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
public class SharpeiCleanupYtSupplyTask extends OnetimeTaskSupport<SharpeiCleanupYtSupplyTask.Parameters> {

    private final BazingaSharpeiCleanupManager bazingaSharpeiCleanupManager;
    private final String sharpeiId;

    public SharpeiCleanupYtSupplyTask(String path, Long lowerIndex, String sharpeiId) {
        super(new Parameters(path, lowerIndex));
        this.bazingaSharpeiCleanupManager = null;
        this.sharpeiId = sharpeiId;
    }

    public SharpeiCleanupYtSupplyTask(BazingaSharpeiCleanupManager bazingaSharpeiCleanupManager, String sharpeiId) {
        super(SharpeiCleanupYtSupplyTask.Parameters.class);
        this.bazingaSharpeiCleanupManager = bazingaSharpeiCleanupManager;
        this.sharpeiId = sharpeiId;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(12);
    }

    @Override
    public TaskQueueName queueName() {
        return MigratorTaskQueueName.YT_SUPPLY;
    }

    @Override
    public TaskId id() {
        return new TaskId(super.id().getId() + "_" + sharpeiId);
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        bazingaSharpeiCleanupManager.addUsersFromYt(parameters.path, parameters.lowerIndex);
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters  {
        private final String path;
        private long lowerIndex;
    }
}
