package ru.yandex.chemodan.app.monops.admin;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.monops.awacs.AwacsBalancerManager;
import ru.yandex.chemodan.app.monops.cluster.DelayedCloseDCZkRegistry;
import ru.yandex.chemodan.app.monops.cluster.InfraEventsZkRegistry;
import ru.yandex.chemodan.app.monops.cluster.ManagedAppsZkRegistry;
import ru.yandex.chemodan.app.monops.worker.ClusterController;
import ru.yandex.chemodan.app.monops.worker.ClusterInfoRegistry;
import ru.yandex.chemodan.app.monops.worker.DelayedCloseController;
import ru.yandex.chemodan.dc.closing.ClosedDataCenterZkRegistry;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.alive2.AliveAppsHolder;
import ru.yandex.inside.infra.InfraApiClient;


/**
 * @author tolmalev
 */
@Configuration
public class MonopsAdminContextConfiguration {
    @Autowired
    AdminApp adminApp;

    @Bean
    public InfraApiClient infraApiClient(@Value("${infra-api.token:-fake_token}") String token) {
        return new InfraApiClient(token);
    }

    @Bean
    public MonopsMainAdminPage monopsMainAdminPage(ClusterController clusterController, ClusterInfoRegistry registry,
            ClosedDataCenterZkRegistry closedDataCenterZkRegistry, AliveAppsHolder aliveAppsHolder,
            ManagedAppsZkRegistry managedAppsZkRegistry, InfraEventsZkRegistry infraEventsZkRegistry,
            InfraApiClient infraApiClient,
            @Value("${infra-api.service-id}") Integer serviceId,
            @Value("${infra-api.environment-id}") Integer environmentId,
            DelayedCloseController delayedCloseController, DelayedCloseDCZkRegistry delayedCloseDCZkRegistry,
            AwacsBalancerManager awacsBalancerManager
    )
    {
        MonopsMainAdminPage adminPage = new MonopsMainAdminPage(
                clusterController, registry, closedDataCenterZkRegistry, aliveAppsHolder, managedAppsZkRegistry,
                infraEventsZkRegistry, infraApiClient, serviceId, environmentId, delayedCloseDCZkRegistry,
                awacsBalancerManager);

        adminApp.registerAdminPage("Monitor", Option.of("Monops"), adminPage);
        return adminPage;
    }
}
