<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>

    <xsl:variable name="app_name" select="/page/content/state/app/name"/>
    <xsl:variable name="warns_count" select="count(/page/content/state/juggler-warns)"/>
    <xsl:variable name="crits_count" select="count(/page/content/state/juggler-crits)"/>
    <xsl:variable name="j_events_count" select="sum($warns_count, $crits_count)"/>

    <xsl:variable name="qloud_project" select="/page/content/state/app/qloud-binding/project"/>
    <xsl:variable name="qloud_application" select="/page/content/state/app/qloud-binding/application"/>
    <xsl:variable name="qloud_environment" select="/page/content/state/app/qloud-binding/environment"/>

    <xsl:variable name="csrf_token" select="/page/content/csrf-token"/>

    <xsl:template match="page" mode="additional-script">
        <script src="https://d3js.org/d3.v3.min.js"/>
        <script type="text/javascript" src="/z/r/monops-monitor/MonopsMainAdminPage-app_info.js"/>
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
        <link rel="stylesheet" type="text/css" href="/z/r/monops-monitor/MonopsMainAdminPage-app_info.css"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container" width="100%">
                <table width="100%">
                    <tr>
                        <td width="30%">
                            <h1>
                                <xsl:value-of select="$app_name"/>
                            </h1>
                        </td>
                        <td>
                            <xsl:choose>
                                <xsl:when test="state/app/qloud-binding">
                                    <xsl:apply-templates select="state/qloud-state"/>
                                    <br/>
                                    <br/>
                                    <xsl:apply-templates select="state/app/qloud-binding"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:call-template name="qloud-binding-edit-form">
                                        <xsl:with-param name="binding" select="qloud-binding"/>
                                    </xsl:call-template>
                                    <a href="#" data-toggle="modal" data-target="#editQloudBinding">
                                        Привязать к <b>qloud</b>
                                    </a>
                                </xsl:otherwise>
                            </xsl:choose>
                        </td>
                    </tr>
                </table>

                <xsl:apply-templates select="state"/>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="app">
        <hr/>
        <xsl:apply-templates select="." mode="dashboard-links"/>
        <hr/>
        <xsl:apply-templates select="." mode="useful-links"/>
        <hr/>
        <xsl:apply-templates select="." mode="awacs-balancers"/>
    </xsl:template>

    <xsl:template name="qloud-binding-edit-form">
        <xsl:param name="binding"/>

        <div class="modal fade" id="editQloudBinding" tabindex="-1" role="dialog" aria-labelledby="editQloudBinding" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <xsl:if test="binding/project">
                            <h3>Редактировать привязку к qloud</h3>
                        </xsl:if>
                        <xsl:if test="not(binding/project)">
                            <h3>Создать привязку к qloud</h3>
                        </xsl:if>
                    </div>
                    <div class="modal-body">
                        <form action="/z/monops-monitor/app/set_qloud_binding" method="POST">
                            <input class="form-control" name="app" type="hidden" value="{$app_name}"/>
                            <input class="form-control" name="token" type="hidden" value="{$csrf_token}"/>
                            <div class="form-group row">
                                <label for="project" class="col-sm-2 col-form-label">project</label>
                                <div class="col-sm-5">
                                    <input class="form-control" name="project" type="text" value="{$binding/project}"/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="application" class="col-sm-2 col-form-label">application</label>
                                <div class="col-sm-5">
                                    <input class="form-control" name="application" type="text" value="{$binding/application}"/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="environment" class="col-sm-2 col-form-label">environment</label>
                                <div class="col-sm-5">
                                    <input class="form-control" name="environment" type="text" value="{$binding/environment}"/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="component" class="col-sm-2 col-form-label">component (optional)</label>
                                <div class="col-sm-5">
                                    <input class="form-control" name="component" type="text" value="{$binding/component}"/>
                                </div>
                            </div>
                            <button class="btn btn-primary">Сохранить</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="qloud-binding">
        <xsl:call-template name="qloud-binding-edit-form">
            <xsl:with-param name="binding" select="."/>
        </xsl:call-template>
        <div class="edit_buttons">
            <a href="/z/monops-monitor/app/remove_qloud_binding?app={$app_name}&amp;token={$csrf_token}" onclick="return confirm('Удалить привязку к qloud?')">☓</a>
            <text> </text>
        </div>
        <a href="https://qloud-ext.yandex-team.ru/projects/{project}/{application}/{environment}">Qloud environment</a>
        (
            <a href="https://qloud-ext.yandex-team.ru/projects/{project}/{application}/{environment}?tab=dashboard">Dashboard</a>,
            <a href="https://qloud-ext.yandex-team.ru/projects/{project}/{application}/{environment}?panel=resources&amp;tab=dashboard">Resources</a>
        )
        <a href="#" data-toggle="modal" data-target="#editQloudBinding">
            <span class="glyphicon glyphicon-edit" style="font-size:15px;"/>
        </a>
    </xsl:template>

    <xsl:template match="qloud-state">
        <xsl:value-of select="z:format-date-time(last-creation-date)"/>
        <br/>
        <xsl:value-of select="last-comment"/>
    </xsl:template>

    <xsl:template match="app" mode="dashboard-links">
        <xsl:variable name="appName" select="name"/>
        <div class="modal fade" id="addDashboardLinkModal" tabindex="-1" role="dialog" aria-labelledby="addDashboardLinkModal" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3>Добавить новую ссылку</h3>
                    </div>
                    <div class="modal-body">
                        <form action="/z/monops-monitor/app/add_link" method="POST">
                            <input class="form-control" name="app" type="hidden" value="{$appName}"/>
                            <input class="form-control" name="linkType" type="hidden" value="dashboard"/>
                            <div class="form-group row">
                                <label for="url" class="col-sm-2 col-form-label">URL</label>
                                <div class="col-sm-5">
                                    <input class="form-control" name="url" type="text"/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="title" class="col-sm-2 col-form-label">Title</label>
                                <div class="col-sm-5">
                                    <input class="form-control" name="title" type="text"/>
                                </div>
                            </div>
                            <button class="btn btn-primary">Добавить дашборд</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <xsl:if test="count(dashboard-links) = 0">
            <h5>
                <small>Дашборды не заполнены</small>
                <button type="button" class="btn btn-primary btn-link" data-toggle="modal" data-target="#addDashboardLinkModal">Добавить</button>
            </h5>
        </xsl:if>
        <xsl:if test="count(dashboard-links) > 0">
            <h3>Дашборды</h3>
            <ul>
                <xsl:for-each select="dashboard-links">
                    <li>
                        <div width="100%">
                            <div class="edit_buttons">
                                <a href="/z/monops-monitor/app/delete_link?linkType=dashboard&amp;app={$appName}&amp;url={url}" onclick="return confirm('Are you sure?')">☓</a>
                                <xsl:text> </xsl:text>
                                <a href="/z/monops-monitor/app/move_link?linkType=dashboard&amp;app={$appName}&amp;url={url}&amp;dir=-1">↑</a>
                                <xsl:text> </xsl:text>
                                <a href="/z/monops-monitor/app/move_link?linkType=dashboard&amp;app={$appName}&amp;url={url}&amp;dir=1">↓</a>
                            </div>
                            <xsl:text> </xsl:text>
                            <a href="{url}"><xsl:value-of select="title"/></a>
                        </div>
                    </li>
                </xsl:for-each>
            </ul>
            <button type="button" class="btn btn-primary btn-link" data-toggle="modal" data-target="#addDashboardLinkModal">Добавить</button>
        </xsl:if>
    </xsl:template>

    <xsl:template match="app" mode="useful-links">
        <xsl:variable name="appName" select="name"/>
        <div class="modal fade" id="addUsefulLinkModal" tabindex="-1" role="dialog" aria-labelledby="addUsefulLinkModal" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3>Добавить новую ссылку</h3>
                    </div>
                    <div class="modal-body">
                        <form action="/z/monops-monitor/app/add_link" method="POST">
                            <input class="form-control" name="app" type="hidden" value="{$appName}"/>
                            <input class="form-control" name="linkType" type="hidden" value="useful"/>
                            <div class="form-group row">
                                <label for="url" class="col-sm-2 col-form-label">URL</label>
                                <div class="col-sm-5">
                                    <input class="form-control" name="url" type="text"/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="title" class="col-sm-2 col-form-label">Title</label>
                                <div class="col-sm-5">
                                    <input class="form-control" name="title" type="text"/>
                                </div>
                            </div>
                            <button class="btn btn-primary">Добавить ссылку</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <xsl:if test="count(useful-links) = 0">
            <h5>
                <small>Нет полезных ссылок</small>
                <button type="button" class="btn btn-primary btn-link" data-toggle="modal" data-target="#addUsefulLinkModal">Добавить</button>
            </h5>

        </xsl:if>
        <xsl:if test="count(useful-links) > 0">
            <h3>
                Полезные ссылки
            </h3>
            <ul>
                <xsl:for-each select="useful-links">
                    <li>
                        <div width="100%">
                            <div class="edit_buttons">
                                <a href="/z/monops-monitor/app/delete_link?linkType=useful&amp;app={$appName}&amp;url={url}" onclick="return confirm('Are you sure?')">☓</a>
                                <xsl:text> </xsl:text>
                                <a href="/z/monops-monitor/app/move_link?linkType=useful&amp;app={$appName}&amp;url={url}&amp;dir=-1">↑</a>
                                <xsl:text> </xsl:text>
                                <a href="/z/monops-monitor/app/move_link?linkType=useful&amp;app={$appName}&amp;url={url}&amp;dir=1">↓</a>
                            </div>
                            <xsl:text> </xsl:text>
                            <a href="{url}"><xsl:value-of select="title"/></a>
                        </div>
                    </li>
                </xsl:for-each>
            </ul>
            <button type="button" class="btn btn-primary btn-link" data-toggle="modal" data-target="#addUsefulLinkModal">Добавить</button>
        </xsl:if>
        <hr/>
    </xsl:template>

    <xsl:template match="app" mode="awacs-balancers">
        <xsl:variable name="appName" select="name"/>
        <div class="modal fade" id="addAwacsBalancerModal" tabindex="-1" role="dialog" aria-labelledby="addAwacsBalancerModal" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3>Добавить новый awacs балансер</h3>
                    </div>
                    <div class="modal-body">
                        <form action="/z/monops-monitor/app/add_awacs_balancer" method="POST">
                            <input class="form-control" name="app" type="hidden" value="{$appName}"/>
                            <div class="form-group row">
                                <label for="url" class="col-sm-2 col-form-label">Balancer</label>
                                <div class="col-sm-5">
                                    <input class="form-control" name="balancer" type="text"/>
                                </div>
                            </div>
                            <button class="btn btn-primary">Добавить балансер</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <xsl:if test="count(awacs-balancers) = 0">
            <h5>
                <small>Awacs балансеры не добавлены</small>
                <button type="button" class="btn btn-primary btn-link" data-toggle="modal" data-target="#addAwacsBalancerModal">Добавить</button>
            </h5>
        </xsl:if>
        <xsl:if test="count(awacs-balancers) > 0">
            <h3>Awacs балансеры</h3>
            <ul>
                <xsl:for-each select="awacs-balancers">
                    <li>
                        <div width="100%">
                            <div class="edit_buttons">
                                <a href="/z/monops-monitor/app/delete_awacs_balancer?app={$appName}&amp;balancer={.}" onclick="return confirm('Are you sure?')">☓</a>
                            </div>
                            <xsl:text> </xsl:text>
                            <a href="https://nanny.yandex-team.ru/ui/#/awacs/namespaces/list/{.}/show"><xsl:value-of select="."/></a>
                        </div>
                    </li>
                </xsl:for-each>
            </ul>
            <button type="button" class="btn btn-primary btn-link" data-toggle="modal" data-target="#addAwacsBalancerModal">Добавить</button>
        </xsl:if>
    </xsl:template>

    <xsl:template match="service-map">
        <hr/>
        <table width="100%">
            <tr>
                <xsl:if test="http-connections">
                    <td width="50%" style="vertical-align: top;">
                        <h3>HTTP connections</h3>
                        <ul>
                            <xsl:for-each select="http-connections">
                                <li>
                                    <xsl:choose>
                                        <xsl:when test="resolved-monops-app-name">
                                            <a href="/z/monops-monitor/app?app={resolved-monops-app-name}">
                                                <xsl:value-of select="name"/>
                                            </a>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="name"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                    <xsl:if test="hostname">
                                        / <xsl:value-of select="hostname"/>
                                    </xsl:if>
                                    <xsl:text> / </xsl:text>

                                    <a href="https://yasm.yandex-team.ru/template/panel/disk-java-http-requests/prj={$qloud_project}.{$qloud_application}.{$qloud_environment};target={name}/">
                                        yasm
                                    </a>
                                </li>
                            </xsl:for-each>
                        </ul>
                    </td>
                </xsl:if>
                <xsl:if test="jdbc-connections">
                    <td width="50%" style="vertical-align: top;">
                        <h3>DB connections</h3>
                        <ul>
                            <xsl:for-each select="jdbc-connections">
                                <li>
                                    <xsl:value-of select="name"/>
                                    <xsl:text> </xsl:text>
                                    (
                                        <xsl:value-of select="type"/>
                                        <xsl:text> : </xsl:text>
                                        <xsl:value-of select="count(shards)"/> shards
                                    )
                                    <xsl:text> </xsl:text>
                                    <xsl:value-of select="sharpei-host"/>
                                </li>
                            </xsl:for-each>
                        </ul>
                    </td>
                </xsl:if>
            </tr>
        </table>


    </xsl:template>

    <xsl:template match="state">
        <xsl:apply-templates select="app"/>
        <xsl:apply-templates select="service-map"/>
        <hr/>
        <div class="modal fade" id="editJugglerSelectors" tabindex="-1" role="dialog" aria-labelledby="editJugglerSelectors" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3>Редактировать привязку к juggler</h3>
                    </div>
                    <div class="modal-body">
                        <table class="table table-condensed table-bordered table-striped" width="100%">
                            <tr>
                                <th>host</th>
                                <th>service</th>
                                <th/>
                            </tr>
                            <xsl:for-each select="juggler-selectors">
                                <tr>
                                    <td>
                                        <xsl:value-of select="host"/>
                                    </td>
                                    <td>
                                        <xsl:value-of select="service"/>
                                    </td>
                                    <td>
                                        <a href="/z/monops-monitor/app/remove_juggler_selector?host={host}&amp;service={service}&amp;token={$csrf_token}&amp;app={$app_name}"
                                           onclick="return confirm('Вы точно хотите удалить host={host}, service={service}')"
                                        >
                                            Удалить
                                        </a>
                                    </td>
                                </tr>
                            </xsl:for-each>
                        </table>
                        <hr/>
                        <h2>Добавить новый</h2>
                        <form action="/z/monops-monitor/app/add_juggler_selector" method="POST">
                            <input class="form-control" name="app" type="hidden" value="{app/name}"/>
                            <input class="form-control" name="token" type="hidden" value="{$csrf_token}"/>
                            <div class="form-group row">
                                <label for="host" class="col-sm-2 col-form-label">host</label>
                                <div class="col-sm-5">
                                    <input class="form-control" name="host" type="text"/>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="service" class="col-sm-2 col-form-label">service</label>
                                <div class="col-sm-5">
                                    <input class="form-control" name="service" type="text"/>
                                </div>
                            </div>
                            <button class="btn btn-primary">Добавить</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <h3>
            Все события из juggler
            <a href="#" data-toggle="modal" data-target="#editJugglerSelectors">
                <span class="glyphicon glyphicon-edit" style="font-size:15px;"/>
            </a>
        </h3>
        <small>
            <xsl:value-of select="juggler-query"/>
        </small>
        <iframe src="{juggler-ui-warn-and-crit-url}&amp;iframe=true" width="100%" frameborder="0" scrolling="yes" height="400px"/>

        <h4>То, что распарсил monops</h4>

        <xsl:apply-templates select="juggler-crits">
            <xsl:with-param name="label_type" select="string('danger')"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="juggler-warns">
            <xsl:with-param name="label_type" select="string('warning')"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="juggler-warns | juggler-crits">
        <xsl:param name="label_type"/>
        <p>
            <span class="label label-{$label_type}"><xsl:value-of select="service"/></span>
            <br/>
            <xsl:value-of select="description"/>
        </p>
    </xsl:template>

</xsl:stylesheet>
