<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>

    <xsl:variable name="csrf_token" select="/page/content/csrf-token"/>

    <xsl:template match="page" mode="additional-script">
        <script src="https://d3js.org/d3.v3.min.js"/>
        <script type="text/javascript" src="https://yastatic.net/momentjs/2.18.1/moment-with-locales.min.js"/>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/eonasdan-bootstrap-datetimepicker/4.17.47/js/bootstrap-datetimepicker.min.js" integrity="sha512-GDey37RZAxFkpFeJorEUwNoIbkTwsyC736KNSYucu1WJWFK9qTdzYub8ATxktr6Dwke7nbFaioypzbDOQykoRg==" crossorigin="anonymous"></script>
        <script type="text/javascript" src="/z/r/monops-monitor/MonopsMainAdminPage-monitor.js"/>
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/eonasdan-bootstrap-datetimepicker/4.17.47/css/bootstrap-datetimepicker.min.css" integrity="sha512-aEe/ZxePawj0+G2R+AaIxgrQuKT68I28qh+wgLrcAJOz3rxCP+TwrK5SPN+E5I+1IQjNtcfvb96HDagwrKRdBw==" crossorigin="anonymous" />
        <link rel="stylesheet" type="text/css" href="/z/r/monops-monitor/MonopsMainAdminPage-monitor.css"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container" width="100%">
                <xsl:if test="count(closed-data-center-info[is-closed='true']) > 0">
                    <hr/>

                    <xsl:for-each select="closed-data-center-info[is-closed='true']">
                        <xsl:variable name="dc-name" select="dc-name"/>
                        <div class="modal fade" id="openAppModal{dc-name}" tabindex="-1" role="dialog" aria-labelledby="closeDC" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h3>Точно хотите открыть приложение в закрытом ДЦ?</h3>
                                    </div>
                                    <div class="modal-body">
                                        <table width="100%" class="fixed-table table table-striped">
                                            <xsl:for-each select="/page/content/app-names">
                                                <tr>
                                                    <xsl:variable name="app_name" select="."/>
                                                    <td>
                                                        <b><xsl:value-of select="."/>:</b>
                                                    </td>
                                                    <td>
                                                        <a href="/z/monops-monitor/open_app_in_closed_dc?token={$csrf_token}&amp;app={$app_name}&amp;dcName={$dc-name}" class="btn btn-success" onclick="return confirm('Вы точно хотите закрыть {$app_name} в ДЦ {$dc-name}?')">
                                                            open
                                                        </a>
                                                    </td>

                                                </tr>
                                            </xsl:for-each>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </xsl:for-each>

                    <h1 style="color:red">
                        Закрыт дц
                        <!--<xsl:value-of select="closed-data-center-info"/>-->
                        <xsl:for-each select="closed-data-center-info[is-closed='true']">
                            <xsl:variable name="dc-name" select="dc-name"/>
                            <xsl:for-each select="/page/content/dc-infra-events[dc-name=$dc-name]">
                                <xsl:text> </xsl:text>
                                <a href="https://infra.yandex-team.ru/event/{id}"><xsl:value-of select="$dc-name"/></a>
                                <xsl:text> </xsl:text>
                            </xsl:for-each>
                            <xsl:text> </xsl:text>
                            <a href="/z/monops-monitor/open_dc?token={$csrf_token}&amp;dcName={dc-name}" class="btn btn-success" onclick="return confirm('Вы точно хотите открыть ДЦ {dc-name}?')">Открыть</a>
                            <xsl:text> </xsl:text>
                            <a class="btn btn-success" data-toggle="modal" data-target="#openAppModal{dc-name}">Открыть приложение</a>

                        </xsl:for-each>
                        !

                    </h1>
                    <xsl:for-each select="closed-data-center-info[is-closed='true']">
                        <xsl:variable name="dc-name" select="dc-name"/>
                        <xsl:for-each select="excluded-apps">
                            Открыт
                            <b><xsl:value-of select="."/></b>
                            <xsl:text>  </xsl:text>
                            <a href="/z/monops-monitor/remove_app_exclude?token={$csrf_token}&amp;app={.}&amp;dcName={$dc-name}" class="btn btn-danger btn-xs" onclick="return confirm('Вы точно хотите закрыть {.} в ДЦ {$dc-name}?')">закрыть</a>
                            <br/>
                        </xsl:for-each>
                    </xsl:for-each>
                    <hr/>
                </xsl:if>
                <xsl:if test="count(delayed-events[is-db='false']) > 0">
                    <hr/>

                    <xsl:for-each select="delayed-events[is-db='false']">
                        <xsl:variable name="dc-name" select="dc-name"/>
                        <div class="modal fade" id="openAppModal{dc-name}" tabindex="-1" role="dialog" aria-labelledby="closeDC" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h3>Точно хотите открыть приложение в закрытом ДЦ?</h3>
                                    </div>
                                    <div class="modal-body">
                                        <table width="100%" class="fixed-table table table-striped">
                                            <xsl:for-each select="/page/content/app-names">
                                                <tr>
                                                    <xsl:variable name="app_name" select="."/>
                                                    <td>
                                                        <b><xsl:value-of select="."/>:</b>
                                                    </td>
                                                    <td>
                                                        <a href="/z/monops-monitor/open_app_in_closed_dc?token={$csrf_token}&amp;app={$app_name}&amp;dcName={$dc-name}" class="btn btn-success" onclick="return confirm('Вы точно хотите закрыть {$app_name} в ДЦ {$dc-name}?')">
                                                            open
                                                        </a>
                                                    </td>

                                                </tr>
                                            </xsl:for-each>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </xsl:for-each>

                    <h1 style="color:red">
                        Будет закрыт дц
                        <xsl:for-each select="delayed-events[is-db='false']">
                            <xsl:variable name="dc-name" select="dc-name"/>
                            <xsl:value-of select="start-time"/>
                            <xsl:for-each select="/page/content/dc-infra-events[dc-name=$dc-name]">
                                <xsl:text> </xsl:text>
                                <a href="https://infra.yandex-team.ru/event/{id}"><xsl:value-of select="$dc-name"/></a>
                                <xsl:text> </xsl:text>
                            </xsl:for-each>
                            <xsl:text> </xsl:text>
                            <a href="/z/monops-monitor/cancel_delayed_close_dc?token={$csrf_token}&amp;dcName={dc-name}&amp;isDb=false" class="btn btn-success" onclick="return confirm('Вы точно хотите отменить закрытие ДЦ {dc-name}?')">Отменить</a>
                        </xsl:for-each>
                        !
                    </h1>
                </xsl:if>
                <xsl:if test="count(closed-data-center-info[is-dbs-closed='true']) > 0">
                    <hr/>

                    <xsl:for-each select="closed-data-center-info[is-dbs-closed='true']">
                        <xsl:variable name="dc-name" select="dc-name"/>
                        <div class="modal fade" id="openAppModal{dc-name}" tabindex="-1" role="dialog" aria-labelledby="closeDbsDc" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h3>Точно хотите открыть приложение в закрытом ДЦ?</h3>
                                    </div>
                                    <div class="modal-body">
                                        <table width="100%" class="fixed-table table table-striped">
                                            <xsl:for-each select="/page/content/app-names">
                                                <tr>
                                                    <xsl:variable name="app_name" select="."/>
                                                    <td>
                                                        <b><xsl:value-of select="."/>:</b>
                                                    </td>
                                                    <td>
                                                        <a href="/z/monops-monitor/open_app_in_closed_dc?token={$csrf_token}&amp;app={$app_name}&amp;dcName={$dc-name}" class="btn btn-success" onclick="return confirm('Вы точно хотите закрыть {$app_name} в ДЦ {$dc-name}?')">
                                                            open
                                                        </a>
                                                    </td>

                                                </tr>
                                            </xsl:for-each>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </xsl:for-each>

                    <h1 style="color:red">
                        Закрыты базы в дц
                        <!--<xsl:value-of select="closed-data-center-info"/>-->
                        <xsl:for-each select="closed-data-center-info[is-dbs-closed='true']">
                            <xsl:variable name="dc-name" select="dc-name"/>
                            <xsl:for-each select="/page/content/dc-infra-events[dc-name=$dc-name]">
                                <xsl:text> </xsl:text>
                                <a href="https://infra.yandex-team.ru/event/{id}"><xsl:value-of select="$dc-name"/></a>
                                <xsl:text> </xsl:text>
                            </xsl:for-each>
                            <xsl:text> </xsl:text>
                            <a href="/z/monops-monitor/open_dbs_dc?token={$csrf_token}&amp;dcName={dc-name}" class="btn btn-success" onclick="return confirm('Вы точно хотите открыть базы в ДЦ {dc-name}?')">Открыть</a>
                            <xsl:text> </xsl:text>
                            <a class="btn btn-success" data-toggle="modal" data-target="#openAppModal{dc-name}">Открыть приложение</a>

                        </xsl:for-each>
                        !

                    </h1>
                    <xsl:for-each select="closed-data-center-info[is-dbs-closed='true']">
                        <xsl:variable name="dc-name" select="dc-name"/>
                        <xsl:for-each select="excluded-apps">
                            Открыт
                            <b><xsl:value-of select="."/></b>
                            <xsl:text>  </xsl:text>
                            <a href="/z/monops-monitor/remove_app_exclude?token={$csrf_token}&amp;app={.}&amp;dcName={$dc-name}" class="btn btn-danger btn-xs" onclick="return confirm('Вы точно хотите закрыть {.} в ДЦ {$dc-name}?')">закрыть</a>
                            <br/>
                        </xsl:for-each>
                    </xsl:for-each>
                    <hr/>
                </xsl:if>
                <xsl:if test="count(delayed-events[is-db='true']) > 0">
                    <hr/>

                    <xsl:for-each select="delayed-events[is-db='true']">
                        <xsl:variable name="dc-name" select="dc-name"/>
                        <div class="modal fade" id="openAppModal{dc-name}" tabindex="-1" role="dialog" aria-labelledby="closeDC" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h3>Точно хотите открыть приложение в закрытом ДЦ?</h3>
                                    </div>
                                    <div class="modal-body">
                                        <table width="100%" class="fixed-table table table-striped">
                                            <xsl:for-each select="/page/content/app-names">
                                                <tr>
                                                    <xsl:variable name="app_name" select="."/>
                                                    <td>
                                                        <b><xsl:value-of select="."/>:</b>
                                                    </td>
                                                    <td>
                                                        <a href="/z/monops-monitor/open_app_in_closed_dc?token={$csrf_token}&amp;app={$app_name}&amp;dcName={$dc-name}" class="btn btn-success" onclick="return confirm('Вы точно хотите закрыть {$app_name} в ДЦ {$dc-name}?')">
                                                            open
                                                        </a>
                                                    </td>

                                                </tr>
                                            </xsl:for-each>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </xsl:for-each>

                    <h1 style="color:red">
                        Будет переключение баз из дц
                        <xsl:for-each select="delayed-events[is-db='true']">
                            <xsl:variable name="dc-name" select="dc-name"/>
                            <xsl:value-of select="start-time"/>
                            <xsl:for-each select="/page/content/dc-infra-events[dc-name=$dc-name]">
                                <xsl:text> </xsl:text>
                                <a href="https://infra.yandex-team.ru/event/{id}"><xsl:value-of select="$dc-name"/></a>
                                <xsl:text> </xsl:text>
                            </xsl:for-each>
                            <xsl:text> </xsl:text>
                            <a href="/z/monops-monitor/cancel_delayed_close_dc?token={$csrf_token}&amp;dcName={dc-name}&amp;isDb=true" class="btn btn-success" onclick="return confirm('Вы точно хотите отменить переключение баз из ДЦ {dc-name}?')">Отменить</a>
                        </xsl:for-each>
                        !

                    </h1>
                </xsl:if>
                <xsl:if test="count(closed-data-center-info[count(force-closed-apps) > 0]) > 0">
                    <hr/>
                    <h2>
                        Закрытые приложения по ДЦ
                    </h2>

                    <xsl:for-each select="closed-data-center-info[count(force-closed-apps) > 0]">
                        <b><xsl:value-of select="dc-name"/></b>:
                        <xsl:for-each select="force-closed-apps">
                            <xsl:value-of select="."/>
                            <xsl:text> </xsl:text>
                            <a href="/z/monops-monitor/open_force_closed_app?token={$csrf_token}&amp;dcName={../dc-name}&amp;app={.}" class="btn btn-success btn-xs" onclick="return confirm('Вы точно хотите открыть {.} в ДЦ {../dc-name}?')">открыть</a>
                            <xsl:text> </xsl:text>
                        </xsl:for-each>
                        <br/>
                    </xsl:for-each>
                    <hr/>
                </xsl:if>

                <div class="modal fade" id="closeOneAppModal" tabindex="-1" role="dialog" aria-labelledby="closeDC" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h3>Точно хотите закрыть приложение в ДЦ?</h3>
                            </div>
                            <div class="modal-body">
                                <table width="100%" class="fixed-table table table-striped">
                                <xsl:for-each select="/page/content/app-names">
                                    <tr>
                                        <xsl:variable name="app_name" select="."/>
                                        <td>
                                            <b><xsl:value-of select="."/>:</b>
                                        </td>
                                        <xsl:for-each select="/page/content/dc-names">
                                            <td width="60px">
                                                <a href="/z/monops-monitor/force_close_app?token={$csrf_token}&amp;app={$app_name}&amp;dcName={.}" class="btn btn-danger" onclick="return confirm('Вы точно хотите закрыть {$app_name} в ДЦ {.}?')">
                                                    <xsl:value-of select="."/>
                                                </a>
                                            </td>
                                        </xsl:for-each>

                                    </tr>
                                </xsl:for-each>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <h1>
                    Пульт дежурного по Диску
                    <xsl:if test="count(closed-data-center-info[is-closed='true']) = 0">
                        <div class="modal fade" id="closeDcModal" tabindex="-1" role="dialog" aria-labelledby="closeDC" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h3>Точно хотите закрыть ДЦ?</h3>
                                    </div>
                                    <div class="modal-body">
                                        <form action="/z/monops-monitor/close_dc" method="POST" class="form-horizontal">
                                            <input type="hidden" name="token" value="{$csrf_token}"/>
                                            <div class="btn-group btn-group-toggle btn-group-justified" data-toggle="buttons">
                                                <label class="btn btn-warning active">
                                                    <input type="radio" name="isDb" value="false" checked="true" />
                                                    Приложения
                                                </label>
                                                <label class="btn btn-danger">
                                                    <input type="radio" name="isDb" value="true"/>
                                                    Увести мастеров
                                                </label>
                                            </div>

                                            <label>Выберите ДЦ</label>

                                            <div class="btn-group btn-group-toggle btn-group-justified" data-toggle="buttons">
                                            <xsl:for-each select="/page/content/dc-names">
                                                <label class="btn btn-default">
                                                    <input type="radio" name="dcName" value="{.}"/>
                                                        <xsl:value-of select="."/>
                                                </label>
                                            </xsl:for-each>
                                            </div>
                                            <h1> </h1>
                                            <div class="input-group">
                                                <span class="input-group-addon">
                                                    <span>Отложить </span>
                                                    <input type="checkbox" name="isDelayed" value="true"/>
                                                </span>
                                                <input type="text" class="form-control" id='startTimeInput' name="startTime" placeholder="YYYY-MM-DDTHH:mm:ss" value=""/>
                                            </div>

                                            <button class="btn btn-danger" type="submit" onclick="return confirm('Вы точно хотите закрыть ДЦ?')">Закрыть</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <a class="btn btn-danger" data-toggle="modal" data-target="#closeDcModal">Закрыть ДЦ</a>
                    </xsl:if>
                    <xsl:text> </xsl:text>
                    <a class="btn btn-small btn-danger" data-toggle="modal" data-target="#closeOneAppModal">Закрыть приложение</a>
                </h1>
                <ul class="nav nav-tabs">
                    <li class="active"><a data-toggle="tab" href="#map">Карта</a></li>
                    <li><a data-toggle="tab" href="#juggler">Juggler</a></li>
                    <li><a data-toggle="tab" href="#components">Компоненты</a></li>
                    <li><a data-toggle="tab" href="#useful_links">Полезные ссылки</a></li>
                    <li><a data-toggle="tab" href="#mpfs_duty">MPFS дежурному</a></li>
                    <li><a data-toggle="tab" href="#java_duty">Java дежурному</a></li>
                </ul>
                <div class="tab-content">
                    <div id="components" class="tab-pane fade">
                        <table class="table table-condensed table-bordered table-striped">
                            <xsl:for-each select="cluster-state/application-states">
                                <xsl:variable name="app_name" select="app/name"/>
                                <tr>
                                    <td width="20%">
                                        <a href="/z/monops-monitor/app?app={$app_name}">
                                            <xsl:value-of select="$app_name"/>
                                        </a>
                                        <xsl:text> </xsl:text>
                                        <a href="{juggler-ui-warn-and-crit-url}">
                                            <span class="glyphicon glyphicon-share-alt" aria-hidden="true"/>
                                        </a>
                                    </td>
                                    <td>
                                        <xsl:call-template name="juggler-label">
                                            <xsl:with-param name="app_name" select="$app_name"/>
                                            <xsl:with-param name="items" select="juggler-warns"/>
                                            <xsl:with-param name="type" select="string('warn')"/>
                                            <xsl:with-param name="label_type" select="string('warning')"/>
                                            <xsl:with-param name="url" select="juggler-ui-warn-url"/>
                                        </xsl:call-template>
                                    </td>
                                    <td>
                                        <xsl:call-template name="juggler-label">
                                            <xsl:with-param name="app_name" select="$app_name"/>
                                            <xsl:with-param name="items" select="juggler-crits"/>
                                            <xsl:with-param name="type" select="string('crit')"/>
                                            <xsl:with-param name="label_type" select="string('danger')"/>
                                            <xsl:with-param name="url" select="juggler-ui-crit-url"/>
                                        </xsl:call-template>
                                    </td>
                                </tr>

                            </xsl:for-each>
                        </table>
                    </div>
                    <div id="useful_links" class="tab-pane fade">
                        <p>
                            Здесь будет куча полезных ссылок которые сложно найти на вики
                        </p>
                        <ul>
                            <li><a href="https://wiki.yandex-team.ru/users/alena/LSR/disklsr/">Disk-LSR</a></li>
                            <li><a href="https://wiki.yandex-team.ru/users/akinfold/PSIncidents/">Как заводить инциденты</a></li>
                            <li><a href="https://tickenator.z.yandex-team.ru/new-ticket?parent_component=disk">Завести инцидент</a></li>
                            <li><a href="https://grafana.yandex-team.ru/dashboard/db/disk_zomb_1">Дашборд для телевизора</a></li>
                        </ul>
                        <hr/>
                        <ul>
                            <li><a href="https://wiki.yandex-team.ru/disk/admin/monitoring/">Настройка мониторингов</a></li>
                            <li><a href="https://wiki.yandex-team.ru/disk/admin/conductor-executer/">Деплой пакетов через conductor-executer</a></li>
                            <li><a href="https://wiki.yandex-team.ru/disk/admin/qloud/">Деплой в Qloud</a></li>
                            <li><a href="https://wiki.yandex-team.ru/disk/admin/deploy/">Деплой в Deploy</a></li>
                        </ul>
                    </div>
                    <div id="mpfs_duty" class="tab-pane fade">
                        <p>
                            Здесь будет полезная инфа для mpfs-дежурного
                        </p>
                        <ul>
                            <li><a href="wiki.yandex-team.ru/disk/mpfs/meps">MEPs</a></li>
                            <li><a href="https://wiki.yandex-team.ru/disk/mpfs/meps/mep-011/">MEP 011 - Дежурство по MPFS</a></li>
                        </ul>
                    </div>
                    <div id="java_duty" class="tab-pane fade">
                        <p>
                            Здесь будет еще полезная инфа для java-дежурного
                        </p>
                        <ul>
                            <li><a href="https://wiki.yandex-team.ru/disk/java/watch/">Watch</a></li>
                            <li><a href="https://wiki.yandex-team.ru/disk/java/faq/">FAQ</a></li>
                            <li><a href="https://st.yandex-team.ru/dashboard/17363">Дашборд задач</a></li>
                        </ul>
                    </div>
                    <div id="map" class="tab-pane fade in active">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="1172px" height="713px" version="1.1" content="&lt;mxfile userAgent=&quot;Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 YaBrowser/19.6.0.1583 Yowser/2.5 Safari/537.36&quot; version=&quot;8.5.0&quot; editor=&quot;www.draw.io&quot; type=&quot;device&quot;&gt;&lt;diagram name=&quot;Page-1&quot; id=&quot;f4b2652c-ad78-7d63-dc60-981670d17f76&quot;&gt;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&lt;/diagram&gt;&lt;/mxfile&gt;" style="background-color: rgb(255, 255, 255);"><defs/><g transform="translate(0.5,0.5)"><path d="M 530 330 L 530 347 Q 530 357 540 357 L 548.5 357 Q 557 357 557 366.82 L 557 376.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 557 381.88 L 553.5 374.88 L 557 376.63 L 560.5 374.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 595 330 L 595 340 Q 595 350 605 350 L 687 350 Q 697 350 697 360 L 697 376.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 697 381.88 L 693.5 374.88 L 697 376.63 L 700.5 374.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="83" y="210" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(119.5,218.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="56" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 56px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">dataapi</div></div></foreignObject><text x="28" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">dataapi</text></switch></g><rect x="83" y="266.5" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(89.5,274.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="116" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 118px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">dataapi_worker</div></div></foreignObject><text x="58" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">dataapi_worker</text></switch></g><rect x="23" y="238" width="50" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(26.5,246.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="42" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 42px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">apidb</div></div></foreignObject><text x="21" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">apidb</text></switch></g><path d="M 772 76 L 782 76 Q 792 76 792 86 L 792 155 Q 792 165 784.5 165 L 780.75 165 Q 777 165 777 175 L 777 238.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 777 243.88 L 773.5 236.88 L 777 238.63 L 780.5 236.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="642" y="50" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(673.5,58.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="66" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 68px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">uploader</div></div></foreignObject><text x="33" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">uploader</text></switch></g><rect x="342" y="190" width="130" height="90" rx="13.5" ry="13.5" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(388.5,225.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="36" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 38px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">mpfs</div></div></foreignObject><text x="18" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">mpfs</text></switch></g><rect x="497" y="295" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(528.5,303.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="66" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 66px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">mworker</div></div></foreignObject><text x="33" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">mworker</text></switch></g><rect x="492" y="383" width="130" height="42" rx="6.3" ry="6.3" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(525.5,394.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="62" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 62px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">mqueue</div></div></foreignObject><text x="31" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">mqueue</text></switch></g><rect x="632" y="383" width="130" height="42" rx="6.3" ry="6.3" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(670.5,394.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="52" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 52px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">queller</div></div></foreignObject><text x="26" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">queller</text></switch></g><rect x="36" y="50" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(80.5,58.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="40" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 42px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">intapi</div></div></foreignObject><text x="20" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">intapi</text></switch></g><rect x="487" y="50" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(522.5,58.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="58" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 60px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">webdav</div></div></foreignObject><text x="29" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">webdav</text></switch></g><path d="M 423 183.63 L 423 120 Q 423 110 433 110 L 641 110 Q 651 110 651 100 L 651 92.5 Q 651 85 659.82 85 L 668.63 85" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 423 188.88 L 419.5 181.88 L 423 183.63 L 426.5 181.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 673.88 85 L 666.88 88.5 L 668.63 85 L 666.88 81.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 617 76 L 617 73 Q 617 70 626.32 70 L 635.63 70" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 640.88 70 L 633.88 73.5 L 635.63 70 L 633.88 66.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 224 87 L 224 86 Q 224 85 223.5 85 L 223.25 85 Q 223 85 223 95 L 223 363.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 223 368.88 L 219.5 361.88 L 223 363.63 L 226.5 361.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="178" y="50" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(208.5,58.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="69" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 70px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">cloud-api</div></div></foreignObject><text x="35" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">cloud-api</text></switch></g><rect x="133" y="370" width="160" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(145.5,378.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="134" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 134px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">smartcache-client</div></div></foreignObject><text x="67" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">smartcache-client</text></switch></g><path d="M 173 465 L 173 495 Q 173 505 183 505 L 236.63 505" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 241.88 505 L 234.88 508.5 L 236.63 505 L 234.88 501.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="133" y="430" width="160" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(140.5,438.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="144" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 146px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">smartcache-worker</div></div></foreignObject><text x="72" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">smartcache-worker</text></switch></g><path d="M 211 85 L 210.5 85 Q 210 85 210 95 L 210 130 Q 210 140 200 140 L 190.5 140 Q 181 140 181 150 L 181 203.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 181 208.88 L 177.5 201.88 L 181 203.63 L 184.5 201.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 213 405 L 213 423.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 213 428.88 L 209.5 421.88 L 213 423.63 L 216.5 421.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 293 448 L 365 448 Q 375 448 375 438 L 375 286.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 375 281.12 L 378.5 288.12 L 375 286.37 L 371.5 288.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="632" y="465" width="130" height="42" rx="6.3" ry="6.3" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(682.5,476.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="28" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 30px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">qdb</div></div></foreignObject><text x="14" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">qdb</text></switch></g><path d="M 697 425 L 697 458.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 697 463.88 L 693.5 456.88 L 697 458.63 L 700.5 456.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="198" y="550.5" width="160" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(232.5,558.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="90" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 90px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">lenta-loader</div></div></foreignObject><text x="45" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">lenta-loader</text></switch></g><path d="M 358 604 L 373 604 Q 383 604 383 594 L 383 515 Q 383 505 376.18 505 L 369.37 505" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 364.12 505 L 371.12 501.5 L 369.37 505 L 371.12 508.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="198" y="595.5" width="160" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(230.5,603.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="94" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 94px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">lenta-worker</div></div></foreignObject><text x="47" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">lenta-worker</text></switch></g><path d="M 358 568 L 397 568 Q 407 568 407 558 L 407 286.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 407 281.12 L 410.5 288.12 L 407 286.37 L 403.5 288.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 358 613 L 397 613 Q 407 613 407 603 L 407 286.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 407 281.12 L 410.5 288.12 L 407 286.37 L 403.5 288.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 198 568 L 46 568 Q 36 568 36 558 L 36 279.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 36 274.12 L 39.5 281.12 L 36 279.37 L 32.5 281.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 198 613 L 46 613 Q 36 613 36 603 L 36 279.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 36 274.12 L 39.5 281.12 L 36 279.37 L 32.5 281.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="63" y="398" width="60" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(67.5,406.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="50" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 52px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">smcdb</div></div></foreignObject><text x="25" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">smcdb</text></switch></g><path d="M 173 405 L 173 410.5 Q 173 416 163 416 L 129.37 416" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 124.12 416 L 131.12 412.5 L 129.37 416 L 131.12 419.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 173 430 L 173 423 Q 173 416 163 416 L 129.37 416" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 124.12 416 L 131.12 412.5 L 129.37 416 L 131.12 419.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 368 666 L 413 666 Q 423 666 423 656 L 423 286.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 423 281.12 L 426.5 288.12 L 423 286.37 L 419.5 288.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="243" y="648.5" width="125" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(279.5,656.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="51" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 53px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">notifier</div></div></foreignObject><text x="26" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">notifier</text></switch></g><path d="M 243 666 L 46 666 Q 36 666 36 656 L 36 279.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 36 274.12 L 39.5 281.12 L 36 279.37 L 32.5 281.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 1092 85 L 1092 99 Q 1092 109 1087.5 109 L 1085.25 109 Q 1083 109 1083 117.82 L 1083 126.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 1083 131.88 L 1079.5 124.88 L 1083 126.63 L 1086.5 124.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 1060 85 L 1013 85 Q 1003 85 1003 95 L 1003 274 Q 1003 284 1009.82 284 L 1016.63 284" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 1021.88 284 L 1014.88 287.5 L 1016.63 284 L 1014.88 280.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="1027" y="50" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(1054.5,58.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="74" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 76px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">streaming</div></div></foreignObject><text x="37" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">streaming</text></switch></g><rect x="1023" y="133" width="120" height="45" rx="6.75" ry="6.75" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(1043.5,146.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="78" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 80px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">mulcagate</div></div></foreignObject><text x="39" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">mulcagate</text></switch></g><rect x="1023" y="260" width="120" height="48" rx="7.2" ry="7.2" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(1063.5,274.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="38" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 38px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">MDS</div></div></foreignObject><text x="19" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">MDS</text></switch></g><path d="M 707 85 L 693 85 Q 683 85 683 95 L 683 102.5 Q 683 110 693 110 L 783 110 Q 793 110 793 120 L 793 134 Q 793 144 803 144 L 1023 144" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 890 85 L 873 85 L 873 91.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 873 96.88 L 869.5 89.88 L 873 91.63 L 876.5 89.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="792" y="50" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(812.5,58.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="88" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 88px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">downloader</div></div></foreignObject><text x="44" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">downloader</text></switch></g><path d="M 857 85 L 857 134 Q 857 144 867 144 L 1023 144" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 463 190 L 463 170 Q 463 160 473 160 L 1013 160 Q 1023 160 1023 158 L 1023 156" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="1023" y="195" width="120" height="47" rx="7.05" ry="7.05" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(1054.5,209.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="56" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 56px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">avatars</div></div></foreignObject><text x="28" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">avatars</text></switch></g><path d="M 857 85 L 857 209 Q 857 219 867 219 L 1016.63 219" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 1021.88 219 L 1014.88 222.5 L 1016.63 219 L 1014.88 215.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 740 85 L 740 220 Q 740 230 750 230 L 1016.63 230" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 1021.88 230 L 1014.88 233.5 L 1016.63 230 L 1014.88 226.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 623 295 L 623 287.5 Q 623 280 633 280 L 643 280 Q 653 280 653 270 L 653 170 Q 653 160 663 160 L 1013 160 Q 1023 160 1023 158 L 1023 156" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 398 85 L 393 85 Q 388 85 388 95 L 388 128 Q 388 138 398 138 L 405.5 138 Q 413 138 413 148 L 413 183.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 413 188.88 L 409.5 181.88 L 413 183.63 L 416.5 181.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="323" y="40" width="150" height="45" rx="6.75" ry="6.75" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(357.5,53.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="80" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 80px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">front-client</div></div></foreignObject><text x="40" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">front-client</text></switch></g><path d="M 552 85 L 538 85 Q 528 85 528 95 L 528 102.5 Q 528 110 518 110 L 408 110 Q 398 110 398 120 L 398 183.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 398 188.88 L 394.5 181.88 L 398 183.63 L 401.5 181.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 361 85 L 361 92.5 Q 361 100 358 100 L 356.5 100 Q 355 100 345 100 L 286 100 Q 276 100 276 95.68 L 276 91.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 276 86.12 L 279.5 93.12 L 276 91.37 L 272.5 93.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 276 85 L 276 120 Q 276 130 286 130 L 365 130 Q 375 130 375 140 L 375 183.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 375 188.88 L 371.5 181.88 L 375 183.63 L 378.5 181.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 134 85 L 134 130 Q 134 140 144 140 L 353 140 Q 363 140 363 150 L 363 183.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 363 188.88 L 359.5 181.88 L 363 183.63 L 366.5 181.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 101 85 L 101 130 Q 101 140 108 140 L 111.5 140 Q 115 140 115 150 L 115 203.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 115 208.88 L 111.5 201.88 L 115 203.63 L 118.5 201.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 83 219 L 45 219 Q 35 219 35 225.32 L 35 231.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 35 236.88 L 31.5 229.88 L 35 231.63 L 38.5 229.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 83 293 L 83 291.5 Q 83 290 73 290 L 45 290 Q 35 290 35 284.68 L 35 279.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 35 274.12 L 38.5 281.12 L 35 279.37 L 31.5 281.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="503" y="190" width="119" height="90" rx="13.5" ry="13.5" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(534.5,225.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="55" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 55px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">djfs-api</div></div></foreignObject><text x="28" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">djfs-api</text></switch></g><path d="M 472 235 L 496.63 235" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 501.88 235 L 494.88 238.5 L 496.63 235 L 494.88 231.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 707 295 L 707 287.5 Q 707 280 697 280 L 663 280 Q 653 280 653 270 L 653 170 Q 653 160 663 160 L 1016.63 160" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 1021.88 160 L 1014.88 163.5 L 1016.63 160 L 1014.88 156.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="642" y="295" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(664.5,303.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="84" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 84px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">djfs-worker</div></div></foreignObject><text x="42" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">djfs-worker</text></switch></g><path d="M 675 330 L 675 347 Q 675 357 665 357 L 567 357 Q 557 357 557 366.82 L 557 376.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 557 381.88 L 553.5 374.88 L 557 376.63 L 560.5 374.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 740 330 L 740 340 Q 740 350 735.5 350 L 733.25 350 Q 731 350 721 350 L 707 350 Q 697 350 697 360 L 697 376.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 697 381.88 L 693.5 374.88 L 697 376.63 L 700.5 374.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="233" y="210" width="100" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(237.5,218.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="90" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 92px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">urlshortener</div></div></foreignObject><text x="45" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">urlshortener</text></switch></g><rect x="178" y="0" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(200.5,8.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="84" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 86px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">front-public</div></div></foreignObject><text x="42" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">front-public</text></switch></g><rect x="325" y="0" width="149" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(331.5,8.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="135" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 137px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">front-client-mobile</div></div></foreignObject><text x="68" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">front-client-mobile</text></switch></g><rect x="0.5" y="0" width="165" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(13.5,8.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="139" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 141px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">front-public-mobile</div></div></foreignObject><text x="70" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">front-public-mobile</text></switch></g><path d="M 388 85 L 388 130 Q 388 140 378 140 L 293 140 Q 283 140 283 150 L 283 203.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 283 208.88 L 279.5 201.88 L 283 203.63 L 286.5 201.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 342 270 L 293 270 Q 283 270 283 260.68 L 283 251.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 283 246.12 L 286.5 253.12 L 283 251.37 L 279.5 253.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="607" y="115.5" width="155" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(615.5,123.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="137" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 139px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">uploader-balancer</div></div></foreignObject><text x="69" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">uploader-balancer</text></switch></g><path d="M 443 190 L 443 143 Q 443 133 453 133 L 600.63 133" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 605.88 133 L 598.88 136.5 L 600.63 133 L 598.88 129.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="793" y="465" width="130" height="42" rx="6.3" ry="6.3" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(827.5,476.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="60" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 62px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">pworker</div></div></foreignObject><text x="30" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">pworker</text></switch></g><path d="M 793 486 L 768.37 486" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 763.12 486 L 770.12 482.5 L 768.37 486 L 770.12 489.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 923 457 L 943 457 L 946.63 457" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 951.88 457 L 944.88 460.5 L 946.63 457 L 944.88 453.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="793" y="446" width="130" height="21" rx="3.15" ry="3.15" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(811.5,447.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="92" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 92px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">mpfs-scripts</div></div></foreignObject><text x="46" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">mpfs-scripts</text></switch></g><path d="M 1083 465 L 1083 461 Q 1083 457 1093 457 L 1153 457 Q 1163 457 1163 447 L 1163 229 Q 1163 219 1156.18 219 L 1149.37 219" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 1144.12 219 L 1151.12 215.5 L 1149.37 219 L 1151.12 222.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 1083 457 L 1153 457 Q 1163 457 1163 447 L 1163 166 Q 1163 156 1156.18 156 L 1149.37 156" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 1144.12 156 L 1151.12 152.5 L 1149.37 156 L 1151.12 159.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="953" y="439" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(980.5,447.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="74" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 74px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">previewer</div></div></foreignObject><text x="37" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">previewer</text></switch></g><path d="M 933 116 L 978 116 L 978 156 L 1016.63 156" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 1021.88 156 L 1014.88 159.5 L 1016.63 156 L 1014.88 152.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 893 133 L 893 150 Q 893 160 883 160 L 385 160 Q 375 160 375 170 L 375 183.63" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 375 188.88 L 371.5 181.88 L 375 183.63 L 378.5 181.88 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="853" y="98" width="80" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(869.5,106.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="46" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 48px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">zipper</div></div></foreignObject><text x="23" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">zipper</text></switch></g><path d="M 748 654 L 674.37 654" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 669.12 654 L 676.12 650.5 L 674.37 654 L 676.12 657.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="748" y="639" width="120" height="30" rx="4.5" ry="4.5" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(779.5,644.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="56" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 56px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">fact-api</div></div></foreignObject><text x="28" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">fact-api</text></switch></g><path d="M 748 684 L 748 687 Q 748 690 738 690 L 648 690 Q 638 690 638 687.18 L 638 684.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 638 679.12 L 641.5 686.12 L 638 684.37 L 634.5 686.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="748" y="669" width="120" height="30" rx="4.5" ry="4.5" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(753.5,674.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="108" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 108px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">fact-processor</div></div></foreignObject><text x="54" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">fact-processor</text></switch></g><path d="M 608 630 L 608 610 Q 608 600 618 600 L 848 600 Q 858 600 858 590.68 L 858 581.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 858 576.12 L 861.5 583.12 L 858 581.37 L 854.5 583.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 548 666 L 468 666 Q 458 666 458 676 L 458 694 Q 458 704 448 704 L 316 704 Q 306 704 306 697.18 L 306 690.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 306 685.12 L 309.5 692.12 L 306 690.37 L 302.5 692.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 548 654 L 548 647 Q 548 640 538 640 L 188 640 Q 178 640 178 630 L 178 587 Q 178 577 184.82 577 L 191.63 577" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 196.88 577 L 189.88 580.5 L 191.63 577 L 189.88 573.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 578 630 L 578 613 Q 578 603 568 603 L 551 603 Q 541 603 541 593 L 541 581.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 541 576.12 L 544.5 583.12 L 541 581.37 L 537.5 583.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="548" y="630" width="120" height="48" rx="7.2" ry="7.2" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(568.5,644.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="78" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 80px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">LogBroker</div></div></foreignObject><text x="39" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">LogBroker</text></switch></g><path d="M 793 554 L 768.37 554" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 763.12 554 L 770.12 550.5 L 768.37 554 L 770.12 557.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="793" y="533" width="130" height="42" rx="6.3" ry="6.3" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(804.5,544.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="106" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 106px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">download-stat</div></div></foreignObject><text x="53" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">download-stat</text></switch></g><rect x="632" y="536.5" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(646.5,544.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="100" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 100px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">blockings_db</div></div></foreignObject><text x="50" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">blockings_db</text></switch></g><rect x="243" y="480.5" width="120" height="48" rx="7.2" ry="7.2" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(275.5,495.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="54" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 54px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">Search</div></div></foreignObject><text x="27" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">Search</text></switch></g><path d="M 443 554 L 393 554 Q 383 554 383 544 L 383 515 Q 383 505 376.18 505 L 369.37 505" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 364.12 505 L 371.12 501.5 L 369.37 505 L 371.12 508.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="443" y="533" width="130" height="42" rx="6.3" ry="6.3" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(460.5,544.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="94" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 96px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">event-loader</div></div></foreignObject><text x="47" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">event-loader</text></switch></g><path d="M 947 68 L 928.37 68" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 923.12 68 L 930.12 64.5 L 928.37 68 L 930.12 71.5 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="947" y="50" width="60" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(960.5,58.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="32" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 32px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">fotki</div></div></foreignObject><text x="16" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">fotki</text></switch></g><path d="M 83 336 L 46 336 Q 36 336 36 326 L 36 279.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 36 274.12 L 39.5 281.12 L 36 279.37 L 32.5 281.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 213 336 L 365 336 Q 375 336 375 326 L 375 286.37" fill="none" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><path d="M 375 281.12 L 378.5 288.12 L 375 286.37 L 371.5 288.12 Z" fill="#000000" stroke="#000000" stroke-miterlimit="10" pointer-events="none"/><rect x="83" y="318" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(126.5,326.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="42" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 42px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">notes</div></div></foreignObject><text x="21" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">notes</text></switch></g><rect x="487" y="0" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(507.5,8.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="88" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 90px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">front-widget</div></div></foreignObject><text x="44" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">front-widget</text></switch></g><rect x="642" y="0" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(665.5,8.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="82" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 84px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">front-editor</div></div></foreignObject><text x="41" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">front-editor</text></switch></g><rect x="792" y="0" width="130" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(813.5,8.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="86" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 86px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">front-album</div></div></foreignObject><text x="43" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">front-album</text></switch></g><rect x="947" y="0" width="169" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(958.5,8.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="145" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 145px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">disk-dv-front-stable</div></div></foreignObject><text x="73" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">disk-dv-front-stable</text></switch></g><rect x="953" y="510" width="180" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(1013.5,518.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="58" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 60px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">dv_web</div></div></foreignObject><text x="29" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">dv_web</text></switch></g><rect x="953" y="557" width="180" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(996.5,565.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="92" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 92px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">dv_backend</div></div></foreignObject><text x="46" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">dv_backend</text></switch></g><rect x="953" y="605" width="180" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(963.5,613.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="158" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 160px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">dv_fallback_backend</div></div></foreignObject><text x="79" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">dv_fallback_backend</text></switch></g><rect x="733" y="245" width="176" height="35" rx="5.25" ry="5.25" fill="#ffffff" stroke="#000000" pointer-events="none"/><g transform="translate(781.5,253.5)"><switch><foreignObject style="overflow:visible;" pointer-events="all" width="78" height="18" requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility"><div xmlns="http://www.w3.org/1999/xhtml" style="display: inline-block; font-size: 17px; font-family: Helvetica; color: rgb(0, 0, 0); line-height: 1.2; vertical-align: top; width: 80px; white-space: nowrap; overflow-wrap: normal; text-align: center;"><div xmlns="http://www.w3.org/1999/xhtml" style="display:inline-block;text-align:inherit;text-decoration:inherit;">dv_worker<br /></div></div></foreignObject><text x="39" y="18" fill="#000000" text-anchor="middle" font-size="17px" font-family="Helvetica">dv_worker&lt;br&gt;</text></switch></g></g></svg>
                        <h2> Juggler Dashboard</h2>
                        <iframe src="https://juggler.yandex-team.ru/dashboards/disk_zomb/?iframe=true" width="100%" height="2000px" frameborder="0"/>
                    </div>
                    <div id="juggler" class="tab-pane fade">
                        <iframe src="https://juggler.yandex-team.ru/dashboards/disk_zomb/?iframe=true" width="100%" height="2000px" frameborder="0"/>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>

    <xsl:template name="juggler-label">
        <xsl:param name="app_name"/>
        <xsl:param name="type"/>
        <xsl:param name="label_type"/>
        <xsl:param name="items"/>
        <xsl:param name="url"/>

        <xsl:if test="count($items) > 0">
            <xsl:variable name="collapse_id" select="concat('collapse_', $type, '_', $app_name)"/>
            <a class="label label-{$label_type}" data-toggle="collapse" href="#{$collapse_id}" aria-expanded="false"
               aria-controls="{$collapse_id}">
                <xsl:value-of select="count($items)"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="$type"/>
            </a>
            <xsl:text> </xsl:text>
            <a href="{$url}">
                <span class="glyphicon glyphicon-share-alt" aria-hidden="true"/>
            </a>
            <div class="collapse" id="{$collapse_id}">
                <xsl:for-each select="$items">
                    <p>
                        <b>
                            <xsl:value-of select="service"/>
                        </b>
                        <br/>
                        <xsl:value-of select="description"/>
                    </p>
                </xsl:for-each>
            </div>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
