package ru.yandex.chemodan.app.monops.awacs;

import java.util.function.BiConsumer;

import ru.yandex.chemodan.app.monops.cluster.ApplicationInfo;
import ru.yandex.chemodan.app.monops.worker.ClusterController;
import ru.yandex.commune.util.RetryUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author friendlyevil
 */
public class AwacsBalancerManager {
    private static final Logger logger = LoggerFactory.getLogger(AwacsBalancerManager.class);

    private final AwacsBalancerController balancerController;
    private final ClusterController clusterController;

    public AwacsBalancerManager(AwacsBalancerController balancerController, ClusterController clusterController) {
        this.balancerController = balancerController;
        this.clusterController = clusterController;
    }

    public void openAllBalancers(String dc) {
        clusterController.getClusterInfo().getApplications().forEach(appInfo -> openAwacsBalancers(appInfo, dc));
    }

    public void closeAllBalancers(String dc) {
        clusterController.getClusterInfo().getApplications().forEach(appInfo -> closeAwacsBalancers(appInfo, dc));
    }

    public void openAwacsBalancers(String app, String dc) {
        processAllAwacsBalancers(app, dc, balancerController::openBalancer);
    }

    public void openAwacsBalancers(ApplicationInfo appInfo, String dc) {
        processAllAwacsBalancers(appInfo, dc, balancerController::openBalancer);
    }

    public void closeAwacsBalancers(String app, String dc) {
        processAllAwacsBalancers(app, dc, balancerController::closeBalancer);
    }

    public void closeAwacsBalancers(ApplicationInfo appInfo, String dc) {
        processAllAwacsBalancers(appInfo, dc, balancerController::closeBalancer);
    }

    private void processAllAwacsBalancers(String app, String dc, BiConsumer<String, String> processF) {
        clusterController.getApplicationInfo(app).ifPresent(appInfo -> processAllAwacsBalancers(appInfo, dc, processF));
    }

    private void processAllAwacsBalancers(ApplicationInfo appInfo, String dc, BiConsumer<String, String> processF) {
        RetryUtils.retry(logger, 3, () ->
                appInfo.getAwacsBalancers().forEach(balancer -> processF.accept(balancer, dc)));
    }
}
