package ru.yandex.chemodan.app.monops.awacs;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.monops.worker.ClusterController;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;

/**
 * @author friendlyevil
 */
@Configuration
public class AwacsControllerContextConfiguration {
    @Bean
    public AwacsBalancerManager awacsBalancerManager(AwacsBalancerController awacsBalancerController,
                                                     ClusterController clusterController) {
        return new AwacsBalancerManager(awacsBalancerController, clusterController);
    }

    @Bean
    public AwacsBalancerController awacsBalancerController(AwacsHttpClient awacsClient) {
        return new AwacsBalancerController(awacsClient);
    }

    @Bean
    public AwacsHttpClient awacsClient(@Qualifier("awacs") HttpClient httpClient,
                                       @Value("${awacs.base.url}") String baseUrl,
                                       @Value("${awacs.token}") String token) {
        return new AwacsHttpClient(httpClient, baseUrl, token);
    }

    @Bean
    @Qualifier("awacs")
    public HttpClient awacsHttpClient(HttpClientConfigurator awacsHttpClientConfigurator) {
        return awacsHttpClientConfigurator.configure();
    }

    @Bean
    @OverridableValuePrefix("awacs")
    public HttpClientConfigurator awacsHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
