package ru.yandex.chemodan.app.monops.awacs.entity;

import java.util.Map;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author friendlyevil
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class AwacsLocations {
    private Map<String, AwacsLocationWeights> locations;
    @JsonProperty("fallback_locations")
    private Map<String, AwacsLocationWeights> fallbackLocations;

    public Optional<AwacsLocationWeights> getLocation(String dc) {
        AwacsLocationWeights weights = locations.get(dc.toUpperCase());
        if (weights != null) {
            return Optional.of(weights);
        }

        return Optional.ofNullable(locations.get(dc.toLowerCase()));
    }
}
