package ru.yandex.chemodan.app.monops.cluster;

import lombok.Builder;
import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
@Data
@Builder(toBuilder = true)
@BenderBindAllFields
public class ApplicationInfo {
    public final String name;

    @Builder.Default private ListF<JugglerSelector> jugglerSelectors = Cf.list();
    @Builder.Default private ListF<DashboardLink> dashboardLinks = Cf.list();
    @Builder.Default private ListF<UsefulLink> usefulLinks = Cf.list();
    @Builder.Default private ApplicationMainMetrics mainMetrics = ApplicationMainMetrics.EMPTY;
    @Builder.Default private Option<MonopsQloudBinding> qloudBinding = Option.empty();
    @Builder.Default private ListF<String> aliases = Cf.list();
    @Builder.Default private ListF<String> awacsBalancers = Cf.list();

    public ApplicationInfo(String name) {
        this(name, Cf.list(), Cf.list(), Cf.list(), ApplicationMainMetrics.EMPTY, Option.empty(), Cf.list(), Cf.list());
    }

    public ApplicationInfo(String name,
            ListF<JugglerSelector> jugglerSelectors,
            ListF<DashboardLink> dashboardLinks,
            ListF<UsefulLink> usefulLinks,
            ApplicationMainMetrics mainMetrics,
            Option<MonopsQloudBinding> qloudBinding,
            ListF<String> aliases,
            ListF<String> awacsBalancers)
    {
        this.name = name;
        this.jugglerSelectors = jugglerSelectors;
        this.dashboardLinks = dashboardLinks;
        this.usefulLinks = usefulLinks;
        this.mainMetrics = mainMetrics;
        this.qloudBinding = qloudBinding;
        this.aliases = aliases;
        this.awacsBalancers = awacsBalancers;
    }

    public ListF<JugglerSelector> getJugglerSelectors() {
        if (jugglerSelectors.isEmpty()) {
            return JugglerSelector.defaultSelectorsForApp(name);
        }
        return jugglerSelectors;
    }

    public static String simpleName(String appName) {
        appName = appName.replace("disk", "");

        for (String delim : Cf.list("-", "_")) {
            appName = StringUtils.removeStart(appName, delim);
            appName = StringUtils.removeEnd(appName, delim);
        }

        return appName;
    }

    public ListF<String> getAllAliases() {
        return aliases.plus(getJugglerSelectors().flatMap(s -> s.host)).unique().toList();
    }
}
