package ru.yandex.chemodan.app.monops.cluster;

import lombok.Data;

import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.io.http.UriBuilder;

/**
 * @author tolmalev
 */
@Data
@Bendable
@BenderMembersToBind(MembersToBind.WITH_ANNOTATIONS)
public class ApplicationMetricInfo {
    @BenderPart
    public final Type type;
    @BenderPart
    public final String title;
    @BenderPart
    public final String expression;

    @BenderPart
    public String url() {
        switch (type) {
            case GR:
                return UriBuilder
                        .cons("https://gr-mg.yandex-team.ru/render/")
                        .addParam("from", "-3hour")
                        .addParam("to", "now")
                        .addParam("target", "alias(" + expression + ",'" + title + "')")
                        .build().toString();
            case YASM:
                return "https://yasm.yandex-team.ru/chart/" + expression;
            default:
                return "";
        }
    }

    public enum Type {
        GR,
        YASM
        ;
    }
}
