package ru.yandex.chemodan.app.monops.cluster;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.io.http.UrlUtils;

/**
 * @author tolmalev
 */
@Data
@Builder(toBuilder = true)
@AllArgsConstructor
@BenderMembersToBind(MembersToBind.WITH_ANNOTATIONS)
public class ApplicationState {
    private static final String JUGGLER_UI_BASE = "https://juggler.yandex-team.ru/aggregate_checks";

    @BenderPart
    public final ApplicationInfo app;

    @BenderPart
    public final ListF<JugglerEvent> jugglerWarns;
    @BenderPart
    public final ListF<JugglerEvent> jugglerCrits;

    @BenderPart
    public final ApplicationMainMetricsState mainMetrics;

    @BenderPart
    public final Option<QloudCompactState> qloudState;

    @BenderPart
    public final Option<ExtendedConnectionsInfo> serviceMap;

    public ApplicationState(ApplicationInfo app, ListF<JugglerEvent> jugglerChecks,
                            ApplicationMainMetricsState mainMetrics,
                            Option<QloudCompactState> qloudState,
                            Option<ExtendedConnectionsInfo> serviceMap)
    {
        this.app = app;
        this.jugglerWarns = jugglerChecks.filter(jc -> jc.status == JugglerEvent.Status.WARN);
        this.jugglerCrits = jugglerChecks.filter(jc -> jc.status == JugglerEvent.Status.CRIT);
        this.mainMetrics = mainMetrics;
        this.qloudState = qloudState;
        this.serviceMap = serviceMap;
    }

    @BenderPart
    public String jugglerUiWarnUrl() {
        return UrlUtils.addParameter(JUGGLER_UI_BASE,
                "query", jugglerQuery(),
                "statuses", "WARN");
    }

    @BenderPart
    public String jugglerUiCritUrl() {
        return UrlUtils.addParameter(JUGGLER_UI_BASE,
                "query", jugglerQuery(),
                "statuses", "CRIT");
    }

    @BenderPart
    public String jugglerUiWarnAndCritUrl() {
        return UrlUtils.addParameter(JUGGLER_UI_BASE,
                "query", jugglerQuery(),
                "statuses", "WARN,CRIT");
    }

    @BenderPart
    public ListF<JugglerSelector> jugglerSelectors() {
        return app.getJugglerSelectors();
    }

    @BenderPart
    public String jugglerQuery() {
        return app.getJugglerSelectors().map(JugglerSelector::toQuery).mkString("(", ") | (", ")");
    }
}
