package ru.yandex.chemodan.app.monops.cluster;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author tolmalev
 */
@Data
@Bendable
@BenderMembersToBind(MembersToBind.WITH_ANNOTATIONS)
public class DashboardLink implements UrlProvider {
    @BenderPart
    public final String url;
    @BenderPart
    public final Option<String> title;

    @BenderPart
    public Type getType() {
        if (url.contains("yasm.yandex-team.ru")) {
            return Type.YASM;
        }
        if (url.contains("grafana.yandex-team.ru")) {
            return Type.GRAFANA;
        }
        return Type.GENERIC;
    }

    enum Type {
        GRAFANA,
        YASM,
        GENERIC
        ;
    }
}
